/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TypeTableDefinition
extends TableDefinition {
    protected String typeName = "";
    protected String additional = "";

    public Writer buildCreationWriter(AbstractSession session, Writer writer) {
        try {
            writer.write("CREATE TABLE " + this.getFullName() + " OF " + this.getTypeName() + " (");
            List<String> keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write("PRIMARY KEY (");
                Iterator<String> iterator = keyFields.iterator();
                while (iterator.hasNext()) {
                    writer.write(iterator.next());
                    if (!iterator.hasNext()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
            writer.write(this.additional);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public String getAdditonal() {
        return this.additional;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

