/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl.impl;

import com.sun.enterprise.security.ssl.impl.MasterPasswordImpl;
import com.sun.enterprise.security.ssl.manager.UnifiedX509KeyManager;
import com.sun.enterprise.security.ssl.manager.UnifiedX509TrustManager;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.embedded.Server;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecuritySupportImpl
extends SecuritySupport {
    private static final String DEFAULT_KEYSTORE_PASS = "changeit";
    private static final String DEFAULT_TRUSTSTORE_PASS = "changeit";
    protected static final Logger _logger = LogDomains.getLogger(SecuritySupportImpl.class, (String)"javax.enterprise.system.core.security");
    protected static boolean initialized = false;
    protected static final List<KeyStore> keyStores = new ArrayList<KeyStore>();
    protected static final List<KeyStore> trustStores = new ArrayList<KeyStore>();
    protected static final List<char[]> keyStorePasswords = new ArrayList<char[]>();
    protected static final List<String> tokenNames = new ArrayList<String>();
    private MasterPasswordImpl masterPasswordHelper = null;
    private static boolean instantiated = false;
    private Date initDate = new Date();
    @Inject
    private Habitat habitat;
    @Inject
    private ProcessEnvironment penv;

    public SecuritySupportImpl() {
        this(true);
    }

    protected SecuritySupportImpl(boolean init) {
        if (init) {
            this.initJKS();
        }
    }

    private void initJKS() {
        String keyStoreFileName = null;
        String trustStoreFileName = null;
        keyStoreFileName = System.getProperty("javax.net.ssl.keyStore");
        trustStoreFileName = System.getProperty("javax.net.ssl.trustStore");
        char[] keyStorePass = null;
        char[] trustStorePass = null;
        if (!SecuritySupportImpl.isInstantiated()) {
            if (this.masterPasswordHelper == null && Globals.getDefaultHabitat() != null) {
                this.masterPasswordHelper = (MasterPasswordImpl)Globals.getDefaultHabitat().getByType(MasterPasswordImpl.class);
            }
            if (this.masterPasswordHelper instanceof MasterPasswordImpl) {
                trustStorePass = keyStorePass = this.masterPasswordHelper.getMasterPassword();
            }
        }
        if (keyStorePass == null) {
            keyStorePass = System.getProperty("javax.net.ssl.keyStorePassword", "changeit").toCharArray();
            trustStorePass = System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
        }
        if (!initialized) {
            SecuritySupportImpl.loadStores(null, null, keyStoreFileName, keyStorePass, System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()), trustStoreFileName, trustStorePass, System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
            Arrays.fill(keyStorePass, ' ');
            Arrays.fill(trustStorePass, ' ');
            initialized = true;
        }
    }

    private boolean isEmbeddedServer() {
        List<String> servers = Server.getServerNames();
        return !servers.isEmpty();
    }

    private static synchronized boolean isInstantiated() {
        if (!instantiated) {
            instantiated = true;
            return false;
        }
        return true;
    }

    protected static synchronized void loadStores(String tokenName, Provider provider, String keyStoreFile, char[] keyStorePass, String keyStoreType, String trustStoreFile, char[] trustStorePass, String trustStoreType) {
        try {
            KeyStore keyStore = SecuritySupportImpl.loadKS(keyStoreType, provider, keyStoreFile, keyStorePass);
            KeyStore trustStore = SecuritySupportImpl.loadKS(trustStoreType, provider, trustStoreFile, trustStorePass);
            keyStores.add(keyStore);
            trustStores.add(trustStore);
            keyStorePasswords.add(Arrays.copyOf(keyStorePass, keyStorePass.length));
            tokenNames.add(tokenName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKS(String keyStoreType, Provider provider, String keyStoreFile, char[] keyStorePass) throws Exception {
        KeyStore ks = null;
        ks = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        char[] passphrase = keyStorePass;
        FileInputStream istream = null;
        BufferedInputStream bstream = null;
        try {
            if (keyStoreFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Loading keystoreFile = {0}, keystorePass = {1}", new Object[]{keyStoreFile, keyStorePass});
                }
                istream = new FileInputStream(keyStoreFile);
                bstream = new BufferedInputStream(istream);
            }
            ks.load(bstream, passphrase);
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        return ks;
    }

    public KeyStore[] getKeyStores() {
        return keyStores.toArray(new KeyStore[keyStores.size()]);
    }

    public KeyStore loadNullStore(String type, int index) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ret = KeyStore.getInstance(type);
        ret.load(null, keyStorePasswords.get(index));
        return ret;
    }

    public KeyManager[] getKeyManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore[] kstores = this.getKeyStores();
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        for (int i = 0; i < kstores.length; ++i) {
            this.checkCertificateDates(kstores[i]);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm != null ? algorithm : KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(kstores[i], keyStorePasswords.get(i));
            KeyManager[] kmgrs = kmf.getKeyManagers();
            if (kmgrs == null) continue;
            keyManagers.addAll(Arrays.asList(kmgrs));
        }
        UnifiedX509KeyManager keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), this.getTokenNames());
        return new KeyManager[]{keyManager};
    }

    public TrustManager[] getTrustManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore[] tstores = this.getTrustStores();
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        for (KeyStore tstore : tstores) {
            this.checkCertificateDates(tstore);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm != null ? algorithm : TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(tstore);
            TrustManager[] tmgrs = tmf.getTrustManagers();
            if (tmgrs == null) continue;
            trustManagers.addAll(Arrays.asList(tmgrs));
        }
        TrustManager trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
        return new TrustManager[]{trustManager};
    }

    private void checkCertificateDates(KeyStore store) throws KeyStoreException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert = store.getCertificate(aliases.nextElement());
            if (!(cert instanceof X509Certificate) || !((X509Certificate)cert).getNotAfter().before(this.initDate)) continue;
            _logger.log(Level.SEVERE, "java_security.expired_certificate", cert);
        }
    }

    public KeyStore[] getTrustStores() {
        return trustStores.toArray(new KeyStore[trustStores.size()]);
    }

    public boolean verifyMasterPassword(char[] masterPass) {
        return Arrays.equals(masterPass, keyStorePasswords.get(0));
    }

    public String[] getTokenNames() {
        return tokenNames.toArray(new String[tokenNames.size()]);
    }

    public KeyStore getKeyStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return keyStores.get(idx);
    }

    public KeyStore getTrustStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return trustStores.get(idx);
    }

    private int getTokenIndex(String token) {
        int idx = -1;
        if (token != null && (idx = tokenNames.indexOf(token)) < 0 && _logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "token {0} is not found", token);
        }
        return idx;
    }

    public void synchronizeKeyFile(Object configContext, String fileRealmName) throws Exception {
    }

    public void checkPermission(String key) {
        try {
            if (this.isEmbeddedServer() || this.habitat == null || this.isACC() || this.isNotServerORACC()) {
                return;
            }
            RuntimePermission perm = new RuntimePermission("SSLPassword");
            AccessController.checkPermission(perm);
        }
        catch (AccessControlException e) {
            String message = e.getMessage();
            PropertyPermission perm = new PropertyPermission(key, "read");
            if (message != null) {
                message = message.replace(e.getPermission().toString(), perm.toString());
            }
            throw new AccessControlException(message, perm);
        }
    }

    public boolean isACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isNotServerORACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.checkPermission("javax.net.ssl.keyStorePassword");
        Key key = keyStores.get(keystoreIndex).getKey(alias, keyStorePasswords.get(keystoreIndex));
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }
}

