/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.adapter.cache;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.glassfish.ha.store.spi.BackingStoreFactoryRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="replicated")
public class ShoalBackingStoreProxy
implements Startup,
PostConstruct,
BackingStoreFactory {
    @Inject
    Habitat habitat;
    @Inject
    Events events;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    @Override
    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, "shoal-backing-store-factory");
            return storeFactory.createBackingStore(conf);
        }
        catch (IllegalStateException ex) {
            String msg = "ReplicatedBackingStore requires GMS to be running in the target cluster before the application is deployed. ";
            throw new BackingStoreException("Exception while creating replicated BackingStore. " + msg, ex);
        }
        catch (Exception ex) {
            throw new BackingStoreException("Exception while creating shoal cache", ex);
        }
    }

    public void postConstruct() {
        BackingStoreFactoryRegistry.register("replicated", this);
        Logger.getLogger(ShoalBackingStoreProxy.class.getName()).log(Level.FINE, "Registered SHOAL BackingStore Proxy with persistence-type = replicated");
        EventListener glassfishEventListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                    BackingStoreFactoryRegistry.unregister("replicated");
                    Logger.getLogger(ShoalBackingStoreProxy.class.getName()).log(Level.FINE, "Unregistered SHOAL BackingStore Proxy with persistence-type = replicated");
                }
            }
        };
        this.events.register(glassfishEventListener);
    }

    @Override
    public BackingStoreTransaction createBackingStoreTransaction() {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, "shoal-backing-store-factory");
            return storeFactory.createBackingStoreTransaction();
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while creating shoal cache", ex);
        }
    }
}

