/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;
import org.glassfish.web.loader.WebappClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
MBeanRegistration {
    private static boolean first = true;
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(WebappLoader.class.getName());
    private ObjectName oname;
    private ObjectName controller;
    private WebappClassLoader classLoader = null;
    private Container container = null;
    private int debug = 0;
    protected DefaultContext defaultContext = null;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.glassfish.web.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager(WebappLoader.class.getPackage().getName());
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private ArrayList overridablePackages;
    private boolean ignoreHiddenJarFiles;
    private boolean useMyFaces;
    private boolean initialized = false;

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    @Override
    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addRepository(String repository) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(sm.getString("webappLoader.addRepository", repository));
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            if (!repository.equals(this.repositories[i])) continue;
            return;
        }
        String[] results = new String[this.repositories.length + 1];
        for (int i = 0; i < this.repositories.length; ++i) {
            results[i] = this.repositories[i];
        }
        results[this.repositories.length] = repository;
        this.repositories = results;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(repository);
            this.setClassPath();
        }
    }

    @Override
    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public String[] getRepositories() {
        return (String[])this.repositories.clone();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader.modified();
    }

    public void closeJARs(boolean force) {
        if (this.classLoader != null) {
            this.classLoader.closeJARs(force);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void init() {
        this.initialized = true;
        if (this.oname == null && this.container instanceof StandardContext) {
            try {
                StandardContext ctx = (StandardContext)this.container;
                String path = ctx.getEncodedPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.controller = this.oname = new ObjectName(ctx.getEngineName() + ":type=Loader,path=" + path + ",host=" + ctx.getParent().getName());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error registering loader", e);
            }
        }
        if (this.container == null) {
            // empty if block
        }
    }

    public void destroy() {
        if (this.controller == this.oname) {
            this.oname = null;
        }
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("webappLoader.alreadyStarted"));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(sm.getString("webappLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container.getResources() == null) {
            log.info("No resources for " + this.container);
            return;
        }
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        Class<WebappLoader> clazz = WebappLoader.class;
        synchronized (WebappLoader.class) {
            block16: {
                if (first) {
                    first = false;
                    try {
                        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error registering jndi stream handler", e);
                    }
                    catch (Throwable t) {
                        if (!log.isLoggable(Level.FINE)) break block16;
                        log.fine("Dual registration of jndi stream handler: " + t.getMessage());
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                int i;
                ClassLoader cl = this.createClassLoader();
                this.classLoader = cl instanceof WebappClassLoader ? (WebappClassLoader)cl : new WebappClassLoader(cl);
                this.classLoader.setResources(this.container.getResources());
                this.classLoader.setDebug(this.debug);
                this.classLoader.setDelegate(this.delegate);
                for (i = 0; i < this.repositories.length; ++i) {
                    this.classLoader.addRepository(this.repositories[i]);
                }
                if (this.overridablePackages != null) {
                    for (i = 0; i < this.overridablePackages.size(); ++i) {
                        this.classLoader.addOverridablePackage((String)this.overridablePackages.get(i));
                    }
                    this.overridablePackages = null;
                }
                this.setRepositories();
                this.setClassPath();
                this.setPermissions();
                DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)this.container.getResources());
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "LifecycleException ", t);
                throw new LifecycleException("start: ", t);
            }
            return;
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("webappLoader.notStarted"));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(sm.getString("webappLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        this.stopNestedClassLoader();
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        this.classLoader = null;
        this.destroy();
    }

    public void stopNestedClassLoader() throws LifecycleException {
        try {
            this.classLoader.stop();
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    protected ClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoader classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        Class[] argTypes = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoader)constr.newInstance(args);
        classLoader.setUseMyFaces(this.useMyFaces);
        try {
            classLoader.start();
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
        return classLoader;
    }

    private void log(String message) {
        Logger logger = null;
        String containerName = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + containerName + "]: " + message);
        } else {
            log.info("WebappLoader[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        String containerName = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + containerName + "] " + message, t);
        } else {
            log.log(Level.WARNING, "WebappLoader[" + containerName + "]: " + message, t);
        }
    }

    private void setPermissions() {
        block20: {
            if (!Globals.IS_SECURITY_ENABLED) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                try {
                    String workDirPath = workDir.getCanonicalPath();
                    this.classLoader.addPermission((Permission)new FilePermission(workDirPath, "read,write"));
                    this.classLoader.addPermission((Permission)new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                String path;
                URL rootURL = servletContext.getResource("/");
                this.classLoader.addPermission(rootURL);
                String contextRoot = servletContext.getRealPath("/");
                if (contextRoot != null) {
                    try {
                        contextRoot = new File(contextRoot).getCanonicalPath();
                        this.classLoader.addPermission(contextRoot);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                URL classesURL = servletContext.getResource("/WEB-INF/classes/");
                this.classLoader.addPermission(classesURL);
                URL libURL = servletContext.getResource("/WEB-INF/lib/");
                this.classLoader.addPermission(libURL);
                if (contextRoot != null) {
                    if (libURL != null) {
                        File rootDir = new File(contextRoot);
                        File libDir = new File(rootDir, "WEB-INF/lib/");
                        try {
                            String path2 = libDir.getCanonicalPath();
                            this.classLoader.addPermission(path2);
                        }
                        catch (IOException e) {}
                    }
                    break block20;
                }
                if (workDir == null) break block20;
                if (libURL != null) {
                    File libDir = new File(workDir, "WEB-INF/lib/");
                    try {
                        path = libDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (classesURL != null) {
                    File classesDir = new File(workDir, "WEB-INF/classes/");
                    try {
                        path = classesDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {}
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void setRepositories() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir == null) {
            log.info("No work dir for " + servletContext);
        }
        if (log.isLoggable(Level.FINEST) && workDir != null) {
            log.finest(sm.getString("webappLoader.deploy", workDir.getAbsolutePath()));
        }
        DirContext resources = this.container.getResources();
        String classesPath = "/WEB-INF/classes";
        DirContext classes = null;
        try {
            Object object = resources.lookup(classesPath);
            if (object instanceof DirContext) {
                classes = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (classes != null) {
            File classRepository = null;
            String absoluteClassesPath = servletContext.getRealPath(classesPath);
            if (absoluteClassesPath != null) {
                classRepository = new File(absoluteClassesPath);
            } else {
                classRepository = new File(workDir, classesPath);
                classRepository.mkdirs();
                this.copyDir(classes, classRepository);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest(sm.getString("webappLoader.classDeploy", (Object)classesPath, classRepository.getAbsolutePath()));
            }
        }
        String libPath = "/WEB-INF/lib";
        this.classLoader.setJarPath(libPath);
        DirContext libDir = null;
        try {
            Object object = resources.lookup(libPath);
            if (object instanceof DirContext) {
                libDir = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (libDir != null) {
            boolean copyJars = false;
            String absoluteLibPath = servletContext.getRealPath(libPath);
            File destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                copyJars = true;
                destDir = new File(workDir, libPath);
                destDir.mkdirs();
            }
            if (!copyJars) {
                return;
            }
            try {
                NamingEnumeration<Binding> enumeration = resources.listBindings(libPath);
                while (enumeration.hasMoreElements()) {
                    Resource jarResource;
                    Object obj;
                    Binding binding = (Binding)enumeration.nextElement();
                    String filename = libPath + "/" + binding.getName();
                    if (!filename.endsWith(".jar") && !filename.endsWith(".zip") || binding.getName() != null && binding.getName().startsWith(".") && this.ignoreHiddenJarFiles) continue;
                    File destFile = new File(destDir, binding.getName());
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(sm.getString("webappLoader.jarDeploy", (Object)filename, destFile.getAbsolutePath()));
                    }
                    if ((obj = binding.getObject()) instanceof Resource && this.copy((jarResource = (Resource)obj).streamContent(), new FileOutputStream(destFile))) continue;
                }
            }
            catch (NamingException e) {
            }
            catch (IOException e) {
                this.log("Unable to configure repositories", e);
            }
        }
    }

    private void setClassPath() {
        String baseClasspath;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        if (this.container instanceof StandardContext && (baseClasspath = ((StandardContext)this.container).getCompilerClasspath()) != null) {
            servletContext.setAttribute("org.apache.catalina.jsp_classpath", baseClasspath);
            return;
        }
        StringBuilder classpath = new StringBuilder();
        boolean first = true;
        for (ClassLoader loader = this.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) {
                String cp = this.getClasspath(loader);
                if (cp == null) continue;
                if (!first) {
                    classpath.append(File.pathSeparator);
                } else {
                    first = false;
                }
                classpath.append(cp);
                continue;
            }
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                if (repositories[i] == null) continue;
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring(7);
                } else if (repository.startsWith("file:")) {
                    repository = repository.substring(5);
                } else {
                    if (!repository.startsWith("jndi:")) continue;
                    repository = servletContext.getRealPath(repository.substring(5));
                }
                if (repository.isEmpty()) continue;
                if (!first) {
                    classpath.append(File.pathSeparator);
                } else {
                    first = false;
                }
                classpath.append(repository);
            }
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", classpath.toString());
    }

    private String getClasspath(ClassLoader loader) {
        try {
            Method m = loader.getClass().getMethod("getClasspath", new Class[0]);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getClasspath " + m);
            }
            if (m == null) {
                return null;
            }
            Object o = m.invoke((Object)loader, new Object[0]);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("gotClasspath " + o);
            }
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "getClasspath ", ex);
            }
            return null;
        }
    }

    private boolean copyDir(DirContext srcDir, File destDir) {
        try {
            NamingEnumeration<NameClassPair> enumeration = srcDir.list("");
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String name = ncPair.getName();
                Object object = srcDir.lookup(name);
                File currentFile = new File(destDir, name);
                if (object instanceof Resource) {
                    FileOutputStream os;
                    InputStream is = ((Resource)object).streamContent();
                    if (this.copy(is, os = new FileOutputStream(currentFile))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    FileOutputStream os = new FileOutputStream(currentFile);
                    if (this.copy((InputStream)object, os)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                currentFile.mkdir();
                this.copyDir((DirContext)object, currentFile);
            }
        }
        catch (NamingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
            try {
                os.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    @Override
    public void addOverridablePackage(String packageName) {
        if (this.overridablePackages == null) {
            this.overridablePackages = new ArrayList();
        }
        this.overridablePackages.add(packageName);
    }

    @Override
    public void setIgnoreHiddenJarFiles(boolean ignoreHiddenJarFiles) {
        this.ignoreHiddenJarFiles = ignoreHiddenJarFiles;
    }
}

