/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryWrapper
implements EntityManagerFactory,
Serializable {
    static Logger _logger = LogDomains.getLogger(EntityManagerFactoryWrapper.class, (String)"javax.enterprise.system.util");
    private String unitName;
    private transient InvocationManager invMgr;
    private transient EntityManagerFactory entityManagerFactory;
    private transient ComponentEnvManager compEnvMgr;

    public EntityManagerFactoryWrapper(String unitName, InvocationManager invMgr, ComponentEnvManager compEnvMgr) {
        this.unitName = unitName;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
    }

    private EntityManagerFactory getDelegate() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
            if (this.entityManagerFactory == null) {
                throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
            }
        }
        return this.entityManagerFactory;
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getDelegate().createEntityManager(map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getDelegate().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getDelegate().getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.getDelegate().getProperties();
    }

    public void close() {
        this.getDelegate().close();
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    public Cache getCache() {
        return this.getDelegate().getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getDelegate().getPersistenceUnitUtil();
    }

    static EntityManagerFactory lookupEntityManagerFactory(InvocationManager invMgr, ComponentEnvManager compEnvMgr, String emfUnitName) {
        JndiNameEnvironment desc;
        ComponentInvocation inv = invMgr.getCurrentInvocation();
        EntityManagerFactory emf = null;
        if (inv != null && (desc = compEnvMgr.getCurrentJndiNameEnvironment()) != null) {
            emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory(inv.getInvocationType(), emfUnitName, desc);
        }
        return emf;
    }

    public static EntityManagerFactory lookupEntityManagerFactory(ComponentInvocation.ComponentInvocationType invType, String emfUnitName, Object descriptor) {
        Set emFactories;
        Application app = null;
        WebBundleDescriptor module = null;
        EntityManagerFactory emf = null;
        switch (invType) {
            case EJB_INVOCATION: {
                if (descriptor instanceof EjbDescriptor) {
                    EjbDescriptor ejbDesc = (EjbDescriptor)descriptor;
                    module = (BundleDescriptor)ejbDesc.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
                    app = module.getApplication();
                    break;
                }
            }
            case SERVLET_INVOCATION: {
                module = (WebBundleDescriptor)descriptor;
                app = module.getApplication();
                break;
            }
            case APP_CLIENT_INVOCATION: {
                module = (ApplicationClientDescriptor)descriptor;
                app = module.getApplication();
                break;
            }
        }
        if (module != null) {
            if (emfUnitName != null) {
                emf = module.getEntityManagerFactory(emfUnitName);
            } else {
                emFactories = module.getEntityManagerFactories();
                if (emFactories.size() == 1) {
                    emf = (EntityManagerFactory)emFactories.iterator().next();
                }
            }
        }
        if (app != null && emf == null) {
            if (emfUnitName != null) {
                emf = app.getEntityManagerFactory(emfUnitName, (BundleDescriptor)module);
            } else {
                emFactories = app.getEntityManagerFactories();
                if (emFactories.size() == 1) {
                    emf = (EntityManagerFactory)emFactories.iterator().next();
                }
            }
        }
        return emf;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Habitat defaultHabitat = Globals.getDefaultHabitat();
        this.invMgr = (InvocationManager)defaultHabitat.getByContract(InvocationManager.class);
        this.compEnvMgr = (ComponentEnvManager)defaultHabitat.getByContract(ComponentEnvManager.class);
    }
}

