/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.datatree.impl;

import com.sun.enterprise.util.ObjectAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements TreeNode,
Comparable {
    protected Map<String, TreeNode> children = new ConcurrentHashMap<String, TreeNode>();
    protected String name;
    protected String category;
    protected String description;
    protected boolean enabled = false;
    private static String NAME_SEPARATOR = ".";
    private static String REGEX = "(?<!\\\\)\\.";
    private TreeNode parent = null;
    private String STAR = "*";

    public String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    @Override
    public String getName() {
        return this.decodeName();
    }

    @Override
    public void setName(String aname) {
        if (aname == null) {
            throw new RuntimeException("Flashlight-utils: Tree Node needs a non-null name");
        }
        this.name = this.encodeNodeName(aname);
    }

    @Override
    public Object getValue() {
        if (this.enabled) {
            return this.getChildNodes();
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public TreeNode addChild(TreeNode newChild) {
        if (newChild == null) {
            return null;
        }
        if (newChild.getName() == null) {
            return null;
        }
        newChild.setParent(this);
        return this.children.put(newChild.getName(), newChild);
    }

    @Override
    public String getCompletePathName() {
        if (this.getParent() != null) {
            return this.getParent().getCompletePathName() + NAME_SEPARATOR + this.getName();
        }
        return this.getName();
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public Collection<TreeNode> getChildNodes() {
        return this.children.values();
    }

    @Override
    public Collection<TreeNode> getEnabledChildNodes() {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        for (TreeNode child : this.children.values()) {
            if (!child.isEnabled()) continue;
            childNodes.add(child);
        }
        return childNodes;
    }

    public Enumeration<TreeNode> getChildNodesImmutable() {
        return ((ConcurrentHashMap)this.children).elements();
    }

    @Override
    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    @Override
    public void removeChild(TreeNode oldChild) {
        String child = oldChild.getName();
        if (child != null) {
            this.children.remove(child);
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public TreeNode getChild(String childName) {
        if (childName == null) {
            return null;
        }
        return this.children.get(childName);
    }

    @Override
    public TreeNode getNode(String completeName) {
        if (completeName == null) {
            return null;
        }
        completeName = this.encodePath(completeName);
        Pattern pattern = Pattern.compile(REGEX);
        String[] tokens = pattern.split(completeName);
        TreeNode n = this.findNodeInTree(tokens);
        return n;
    }

    private TreeNode findNodeInTree(String[] tokens) {
        if (tokens == null) {
            return null;
        }
        TreeNode child = this.getChild(tokens[0]);
        if (child == null) {
            child = this.getChild(AbstractTreeNode.decodeName(tokens[0]));
        }
        if (child == null) {
            return null;
        }
        if (tokens.length > 1) {
            child = ((AbstractTreeNode)child).findNodeInTree(this.dropFirstStringToken(tokens));
        }
        return child;
    }

    private String[] dropFirstStringToken(String[] token) {
        if (token.length == 0) {
            return null;
        }
        if (token.length == 1) {
            return null;
        }
        String[] newToken = new String[token.length - 1];
        for (int i = 0; i < newToken.length; ++i) {
            newToken[i] = token[i + 1];
        }
        return newToken;
    }

    @Override
    public List<TreeNode> traverse(boolean ignoreDisabled) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (ignoreDisabled && !this.enabled) {
            return list;
        }
        list.add(this);
        if (!this.hasChildNodes()) {
            return list;
        }
        Collection<TreeNode> childList = this.children.values();
        for (TreeNode node : childList) {
            list.addAll(node.traverse(ignoreDisabled));
        }
        return list;
    }

    @Override
    public List<TreeNode> getNodes(String pattern, boolean ignoreDisabled, boolean gfv2Compatible) {
        pattern = pattern.replace("\\.", "\\\\\\.");
        pattern = pattern.replace("/", "___SLASH___");
        ArrayList<TreeNode> regexMatchedTree = new ArrayList<TreeNode>();
        try {
            if (gfv2Compatible) {
                pattern = this.convertGFv2PatternToRegex(pattern);
            }
            Pattern mPattern = Pattern.compile(pattern);
            List<TreeNode> completeTree = this.traverse(ignoreDisabled);
            for (TreeNode node : completeTree) {
                Matcher matcher2;
                Matcher matcher;
                String path = node.getCompletePathName();
                String path2 = null;
                if (path.indexOf("\\") >= 0) {
                    path2 = path.replace("\\", "");
                }
                if ((matcher = mPattern.matcher(path)).matches()) {
                    regexMatchedTree.add(node);
                    continue;
                }
                if (path2 == null || !(matcher2 = mPattern.matcher(path2)).matches()) continue;
                regexMatchedTree.add(node);
            }
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
        return regexMatchedTree;
    }

    @Override
    public List<TreeNode> getNodes(String pattern) {
        return this.getNodes(pattern, true, true);
    }

    private String convertGFv2PatternToRegex(String pattern) {
        if (pattern.equals(this.STAR)) {
            return ".*";
        }
        String modifiedPattern = pattern.replaceAll("\\*", ":");
        String regex = modifiedPattern.replaceAll(":", ".*");
        return regex;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((TreeNode)o).getName());
    }

    @Override
    public TreeNode getPossibleParentNode(String pattern) {
        if (pattern == null || pattern.length() <= 0 || pattern.indexOf(42) >= 0) {
            return null;
        }
        TreeNode node = null;
        int longest = 0;
        for (TreeNode n : this.traverse(true)) {
            String aname = n.getCompletePathName();
            if (aname == null || !pattern.startsWith(aname) && !pattern.startsWith(aname.replace("\\", ""))) continue;
            int thisLength = aname.length();
            if (node != null && thisLength <= longest) continue;
            node = n;
            longest = thisLength;
        }
        return node;
    }

    private String encodeNodeName(String nodeName) {
        return nodeName.replace("\\.", "___MONDOT___").replace(".", "___MONDOT___").replace("\\/", "___SLASH___").replace("/", "___SLASH___");
    }

    private String encodePath(String thePath) {
        return thePath.replace("\\/", "___SLASH___").replace("\\.", "___MONDOT___");
    }

    private String decodeName() {
        return AbstractTreeNode.decodeName(this.name);
    }

    private static String decodeName(String s) {
        return s.replace("___SLASH___", "/").replace("___MONDOT___", "\\.");
    }
}

