/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.directory.DirContext;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContext
implements ServletContext {
    private static final SecurityPermission GET_UNWRAPPED_CONTEXT_PERMISSION = new SecurityPermission("getUnwrappedContext");
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private HashMap<String, String> readOnlyAttributes = new HashMap();
    private StandardContext context = null;
    private static final List<String> emptyString = Collections.emptyList();
    private static final List<Servlet> emptyServlet = Collections.emptyList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private Map<String, String> parameters = new ConcurrentHashMap<String, String>();
    private volatile boolean parametersMerged = false;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean isRestricted;

    public ApplicationContext(StandardContext context) {
        this.context = context;
        this.setAttribute("com.sun.faces.useMyFaces", context.isUseMyFaces());
    }

    public StandardContext getStandardContext() {
        return this.context;
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    @Override
    public String getContextPath() {
        return this.context.getPath();
    }

    @Override
    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    @Override
    public String getInitParameter(String name) {
        this.mergeParameters();
        return this.parameters.get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        this.mergeParameters();
        return new Enumerator<String>(this.parameters.keySet());
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        try {
            this.context.addParameter(name, value);
            if (this.parametersMerged) {
                this.parameters.put(name, value);
            }
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public int getEffectiveMajorVersion() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getEffectiveMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getEffectiveMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    @Override
    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    @Override
    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    @Override
    public Servlet getServlet(String name) {
        return null;
    }

    @Override
    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    @Override
    public Enumeration<String> getServletNames() {
        return new Enumerator<String>(emptyString);
    }

    @Override
    public Enumeration<Servlet> getServlets() {
        return new Enumerator<Servlet>(emptyServlet);
    }

    @Override
    public void log(String message) {
        this.context.log(message);
    }

    @Override
    public void log(Exception exception, String message) {
        this.context.log(exception, message);
    }

    @Override
    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
        List<EventListener> listeners = this.context.getApplicationEventListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)eventListener;
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            oldValue = this.attributes.get(name);
            if (oldValue != null) {
                replaced = true;
            }
            this.attributes.put(name, value);
        }
        if (name.equals("org.apache.catalina.jsp_classpath") || name.equals("com.sun.jsp.tldUriToLocationMap")) {
            this.setAttributeReadOnly(name);
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)eventListener;
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
            }
            catch (Throwable t) {
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.addServlet(servletName, className);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.addServlet(servletName, servlet);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.addServlet(servletName, servletClass);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.createServlet(clazz);
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getServletRegistration(servletName);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getServletRegistrations();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.addFilter(filterName, className);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.addFilter(filterName, filter);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.addFilter(filterName, filterClass);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.createFilter(clazz);
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getFilterRegistration(filterName);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getFilterRegistrations();
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getSessionCookieConfig();
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getDefaultSessionTrackingModes();
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getEffectiveSessionTrackingModes();
    }

    @Override
    public void addListener(String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        this.context.addListener(className);
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        this.context.addListener(t);
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        this.context.addListener(listenerClass);
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.createListener(clazz);
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getJspConfigDescriptor();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        return this.context.getClassLoader();
    }

    @Override
    public void declareRoles(String ... roleNames) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(sm.getString("applicationContext.restrictedMethod"));
        }
        this.context.declareRoles(roleNames);
    }

    public StandardContext getUnwrappedContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_UNWRAPPED_CONTEXT_PERMISSION);
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAttributes() {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Iterator<String> iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        for (String key : list) {
            this.removeAttribute(key);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeReadOnly(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (this.attributes.containsKey(name)) {
                this.readOnlyAttributes.put(name, name);
            }
        }
    }

    void setRestricted(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void mergeParameters() {
        List<ApplicationParameter> params;
        if (this.parametersMerged) {
            return;
        }
        for (String name : this.context.findParameters()) {
            this.parameters.put(name, this.context.findParameter(name));
        }
        List<ApplicationParameter> list = params = this.context.findApplicationParameters();
        synchronized (list) {
            for (ApplicationParameter param : params) {
                if (param.getOverride()) {
                    if (this.parameters.get(param.getName()) != null) continue;
                    this.parameters.put(param.getName(), param.getValue());
                    continue;
                }
                this.parameters.put(param.getName(), param.getValue());
            }
        }
        this.parametersMerged = true;
    }
}

