/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.xml;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniXmlParser {
    private static final String DEFAULT_ADMIN_VS_ID = "__asadmin";
    private static final String DEFAULT_VS_ID = "server";
    private LoggingConfigImpl loggingConfig = new LoggingConfigImpl();
    private File domainXml;
    private XMLStreamReader parser;
    private InputStreamReader reader;
    private String serverName;
    private String configRef;
    private List<String> jvmOptions = new ArrayList<String>();
    private List<String> profilerJvmOptions = new ArrayList<String>();
    private Map<String, String> javaConfig;
    private Map<String, String> profilerConfig = Collections.emptyMap();
    private Map<String, String> sysProps = new HashMap<String, String>();
    private Map<String, String> profilerSysProps = new HashMap<String, String>();
    private boolean valid = false;
    private List<HostAndPort> adminAddresses = new ArrayList<HostAndPort>();
    private String domainName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MiniXmlParser.class);
    private boolean monitoringEnabled = true;
    private List<Map<String, String>> vsAttributes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> listenerAttributes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> protocolAttributes = new ArrayList<Map<String, String>>();
    private boolean sawNetworkConfig;
    private boolean sawDefaultConfig;

    public MiniXmlParser(File domainXml) throws MiniXmlParserException {
        this(domainXml, DEFAULT_VS_ID);
    }

    public MiniXmlParser(File domainXml, String serverName) throws MiniXmlParserException {
        this.serverName = serverName;
        this.domainXml = domainXml;
        try {
            this.read();
            this.valid = true;
        }
        catch (EndDocumentException e) {
            throw new MiniXmlParserException(strings.get("enddocument", this.configRef, serverName));
        }
        catch (Exception e) {
            throw new MiniXmlParserException(strings.get("toplevel", e), e);
        }
        finally {
            try {
                if (this.parser != null) {
                    this.parser.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Map<String, String> getJavaConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.javaConfig;
    }

    public List<String> getJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.jvmOptions;
    }

    public Map<String, String> getProfilerConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerConfig;
    }

    public List<String> getProfilerJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerJvmOptions;
    }

    public Map<String, String> getProfilerSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerSysProps;
    }

    public Map<String, String> getSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.sysProps;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<HostAndPort> getAdminAddresses() {
        if (this.adminAddresses == null || this.adminAddresses.isEmpty()) {
            String[] listenerNames = this.getListenerNamesForVS(DEFAULT_ADMIN_VS_ID, this.vsAttributes);
            if (listenerNames == null || listenerNames.length == 0) {
                listenerNames = this.getListenerNamesForVS(DEFAULT_VS_ID, this.vsAttributes);
            }
            this.addPortsForListeners(listenerNames);
        }
        return this.adminAddresses;
    }

    public void setupConfigDir(File configDir, File installDir) {
        this.loggingConfig.setupConfigDir(configDir, installDir);
    }

    public String getLogFilename() {
        String logFilename = null;
        try {
            Map<String, String> map = this.loggingConfig.getLoggingProperties();
            if (map != null) {
                logFilename = map.get("com.sun.enterprise.server.logging.GFFileHandler.file");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logFilename;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public boolean hasNetworkConfig() {
        return this.sawNetworkConfig;
    }

    public boolean hasDefaultConfig() {
        return this.sawDefaultConfig;
    }

    private void read() throws XMLStreamException, EndDocumentException, FileNotFoundException {
        this.createParser();
        this.getConfigRefName();
        try {
            this.getConfig();
            this.findDomainNameAndEnd();
            return;
        }
        catch (EndDocumentException ex) {
            this.createParser();
            this.skipRoot("domain");
            this.getConfig();
            this.findDomainNameAndEnd();
            Logger.getLogger(MiniXmlParser.class.getName()).log(Level.FINE, strings.get("secondpass"));
            return;
        }
    }

    private void createParser() throws FileNotFoundException, XMLStreamException {
        this.reader = new InputStreamReader(new FileInputStream(this.domainXml));
        this.parser = this.getXmlInputFactory().createXMLStreamReader(this.domainXml.toURI().toString(), this.reader);
    }

    private XMLInputFactory getXmlInputFactory() {
        Class<XMLInputFactory> clazz = XMLInputFactory.class;
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            return XMLInputFactory.newInstance();
        }
        return XMLInputFactory.newInstance(clazz.getName(), cl);
    }

    private void getConfigRefName() throws XMLStreamException, EndDocumentException {
        if (this.configRef != null) {
            return;
        }
        this.skipRoot("domain");
        while (true) {
            this.skipTo("servers", "property");
            String name = this.parser.getLocalName();
            if ("servers".equals(name)) break;
            this.parseDomainName();
        }
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (!DEFAULT_VS_ID.equals(localName)) {
                throw new XMLStreamException(strings.get("noserver", this.serverName));
            }
            Map<String, String> map = this.parseAttributes();
            String thisName = map.get("name");
            if (this.serverName.equals(thisName)) {
                this.configRef = map.get("config-ref");
                this.parseSysPropsFromServer();
                this.skipToEnd("servers");
                return;
            }
            this.skipToEnd(DEFAULT_VS_ID);
        }
    }

    private void getConfig() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipTo("configs", "property");
            String name = this.parser.getLocalName();
            if ("configs".equals(name)) break;
            this.parseDomainName();
        }
        while (this.skipToButNotPast("configs", "config")) {
            Map<String, String> map = this.parseAttributes();
            String thisName = map.get("name");
            if ("default-config".equals(thisName)) {
                this.sawDefaultConfig = true;
            }
            if (this.configRef.equals(thisName)) {
                this.parseConfig();
                continue;
            }
            this.skipTree("config");
        }
    }

    private void parseConfig() throws XMLStreamException, EndDocumentException {
        while (true) {
            int event;
            if ((event = this.next()) == 2) {
                if (!"config".equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1) continue;
            String name = this.parser.getLocalName();
            if ("system-property".equals(name)) {
                this.parseSystemPropertyNoOverride();
                continue;
            }
            if ("java-config".equals(name)) {
                this.parseJavaConfig();
                continue;
            }
            if ("http-service".equals(name)) {
                this.parseHttpService();
                continue;
            }
            if ("network-config".equals(name)) {
                this.sawNetworkConfig = true;
                this.parseNetworkConfig();
                continue;
            }
            if ("monitoring-service".equals(name)) {
                this.parseMonitoringService();
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseNetworkConfig() throws XMLStreamException, EndDocumentException {
        while (true) {
            int event;
            if ((event = this.next()) == 2) {
                if (!"network-config".equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1) continue;
            String name = this.parser.getLocalName();
            if ("protocols".equals(name)) {
                this.parseProtocols();
                continue;
            }
            if ("network-listeners".equals(name)) {
                this.parseListeners();
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseSysPropsFromServer() throws XMLStreamException, EndDocumentException {
        while (true) {
            int event;
            if ((event = this.next()) == 2) {
                if (!DEFAULT_VS_ID.equals(this.parser.getLocalName())) continue;
                return;
            }
            if (event != 1) continue;
            String name = this.parser.getLocalName();
            if ("system-property".equals(name)) {
                this.parseSystemPropertyWithOverride();
                continue;
            }
            this.skipTree(name);
        }
    }

    private void parseSystemPropertyNoOverride() {
        this.parseSystemProperty(false);
    }

    private void parseSystemPropertyWithOverride() {
        this.parseSystemProperty(true);
    }

    private void parseSystemProperty(boolean override) {
        Map<String, String> map = this.parseAttributes();
        String name = map.get("name");
        String value = map.get("value");
        if (name != null && (override || !this.sysProps.containsKey(name))) {
            this.sysProps.put(name, value);
        }
    }

    private void parseJavaConfig() throws XMLStreamException, EndDocumentException {
        this.javaConfig = this.parseAttributes();
        this.parseJvmAndProfilerOptions();
    }

    private void parseJvmAndProfilerOptions() throws XMLStreamException, EndDocumentException {
        while (this.skipToButNotPast("java-config", "jvm-options", "profiler")) {
            if ("jvm-options".equals(this.parser.getLocalName())) {
                this.jvmOptions.add(this.parser.getElementText());
                continue;
            }
            this.parseProfiler();
        }
    }

    private void parseProfiler() throws XMLStreamException, EndDocumentException {
        this.profilerConfig = this.parseAttributes();
        while (this.skipToButNotPast("profiler", "jvm-options", "property")) {
            if ("jvm-options".equals(this.parser.getLocalName())) {
                this.profilerJvmOptions.add(this.parser.getElementText());
                continue;
            }
            this.parseProperty(this.profilerSysProps);
        }
    }

    private void parseProperty(Map<String, String> map) {
        Map<String, String> prop = this.parseAttributes();
        String name = prop.get("name");
        String value = prop.get("value");
        if (name != null) {
            map.put(name, value);
        }
    }

    private void skipNonStartElements() throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 1) {
        }
    }

    private void skipRoot(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 1) {
        }
        if (!name.equals(this.parser.getLocalName())) {
            throw new XMLStreamException("Unknown Domain XML Layout");
        }
    }

    private void skipTo(String name1, String name2) throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (name1.equals(localName) || name2.equals(localName)) {
                return;
            }
            this.skipTree(localName);
        }
    }

    private boolean skipToButNotPast(String endName, String ... startNames) throws XMLStreamException, EndDocumentException {
        int event;
        do {
            if ((event = this.next()) != 1) continue;
            for (String s : startNames) {
                if (!this.parser.getLocalName().equals(s)) continue;
                return true;
            }
        } while (event != 2 || !this.parser.getLocalName().equals(endName));
        return false;
    }

    private void skipTree(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private void skipToEnd(String name) throws XMLStreamException, EndDocumentException {
        int event;
        while ((event = this.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private int next() throws XMLStreamException, EndDocumentException {
        int event = this.parser.next();
        if (event == 8) {
            this.parser.close();
            throw new EndDocumentException();
        }
        return event;
    }

    private void findDomainNameAndEnd() {
        try {
            while (this.skipToButNotPast("domain", "property")) {
                this.parseDomainName();
            }
            if (this.domainName == null) {
                Logger.getLogger(MiniXmlParser.class.getName()).log(Level.INFO, strings.get("noDomainName"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(strings.get("noDomainEnd"));
        }
    }

    private void parseDomainName() {
        if (this.domainName != null) {
            return;
        }
        Map<String, String> map = this.parseAttributes();
        String name = map.get("name");
        String value = map.get("value");
        if (name == null || value == null) {
            return;
        }
        if ("administrative.domain.name".equals(name)) {
            this.domainName = value;
        }
    }

    private void parseMonitoringService() {
        String s = this.parseAttributes().get("monitoring-enabled");
        this.monitoringEnabled = s == null ? true : !"false".equals(s);
    }

    private void parseHttpService() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipToButNotPast("http-service", "http-listener", "virtual-server");
            String name = this.parser.getLocalName();
            if ("http-listener".equals(name)) {
                this.listenerAttributes.add(this.parseAttributes());
                continue;
            }
            if ("virtual-server".equals(name)) {
                this.vsAttributes.add(this.parseAttributes());
                continue;
            }
            if ("http-service".equals(name)) break;
        }
        String[] listenerNames = this.getListenerNamesForVS(DEFAULT_ADMIN_VS_ID, this.vsAttributes);
        if (listenerNames == null || listenerNames.length == 0) {
            listenerNames = this.getListenerNamesForVS(DEFAULT_VS_ID, this.vsAttributes);
        }
        if (listenerNames == null || listenerNames.length <= 0) {
            return;
        }
        this.addPortsForListeners(listenerNames);
    }

    private void parseListeners() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipToButNotPast("network-listeners", "network-listener");
            String name = this.parser.getLocalName();
            if ("network-listener".equals(name)) {
                this.listenerAttributes.add(this.parseAttributes());
                continue;
            }
            if ("network-listeners".equals(name)) break;
        }
    }

    private void parseProtocols() throws XMLStreamException, EndDocumentException {
        while (true) {
            this.skipToButNotPast("protocols", "protocol");
            String name = this.parser.getLocalName();
            if ("protocol".equals(name)) {
                this.protocolAttributes.add(this.parseAttributes());
                continue;
            }
            if ("protocols".equals(name)) break;
        }
    }

    private String[] getListenerNamesForVS(String vsid, List<Map<String, String>> vsAttributes) {
        String listeners = null;
        String[] listenerArray = null;
        for (Map<String, String> atts : vsAttributes) {
            String id = atts.get("id");
            if (id == null || !id.equals(vsid)) continue;
            listeners = atts.get("network-listeners");
            if (listeners != null) break;
            listeners = atts.get("http-listeners");
            break;
        }
        if (GFLauncherUtils.ok(listeners) && (listenerArray = listeners.split(",")) != null && listenerArray.length <= 0) {
            listenerArray = null;
        }
        if (listenerArray == null) {
            listenerArray = new String[]{};
        }
        return listenerArray;
    }

    private void addPortsForListeners(String[] listenerNames) {
        if (listenerNames != null && listenerNames.length > 0) {
            block0: for (Map<String, String> atts : this.listenerAttributes) {
                String id = atts.get("name");
                if (id == null) {
                    id = atts.get("id");
                }
                if (id == null) continue;
                for (String listenerName : listenerNames) {
                    if (!id.equals(listenerName)) continue;
                    int port = this.getPort(atts.get("port"));
                    if (port < 0) continue block0;
                    String addr = atts.get("address");
                    if (!GFLauncherUtils.ok(addr)) {
                        addr = "localhost";
                    }
                    if (StringUtils.isToken(addr)) {
                        addr = this.sysProps.get(StringUtils.stripToken(addr));
                    }
                    boolean secure = false;
                    String protocol = atts.get("protocol");
                    if ((atts = this.getProtocolByName(protocol)) != null) {
                        String sec = atts.get("security-enabled");
                        boolean bl = secure = sec != null && "true".equalsIgnoreCase(sec);
                    }
                    if (!GFLauncherUtils.ok(addr)) continue block0;
                    this.adminAddresses.add(new HostAndPort(addr, port, secure));
                    continue block0;
                }
            }
        }
    }

    private int getPort(String portString) {
        int port = -1;
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            try {
                portString = this.sysProps.get(StringUtils.stripToken(portString));
                if (portString != null && portString.length() > 0) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return port;
    }

    Map<String, String> getProtocolByName(String name) {
        for (Map<String, String> atts : this.protocolAttributes) {
            String id = atts.get("name");
            if (id == null) {
                id = atts.get("id");
            }
            if (id == null || !id.equals(name)) continue;
            return atts;
        }
        return null;
    }

    private Map<String, String> parseAttributes() {
        int num = this.parser.getAttributeCount();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            map.put(this.parser.getAttributeName(i).getLocalPart(), this.parser.getAttributeValue(i));
        }
        return map;
    }

    private static class EndDocumentException
    extends Exception {
        EndDocumentException() {
        }
    }
}

