/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class ScrConfiguration {
    private static final String VALUE_TRUE = "true";
    private static final String PROP_FACTORY_ENABLED = "ds.factory.enabled";
    private static final String PROP_LOGLEVEL = "ds.loglevel";
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String PROP_SHOWTRACE = "ds.showtrace";
    private static final String PROP_SHOWERRORS = "ds.showerrors";
    private final BundleContext bundleContext;
    private int logLevel;
    private boolean factoryEnabled;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;

    public ScrConfiguration(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configure(null);
        try {
            ManagedService service = new ManagedService(){

                public void updated(Dictionary properties) throws ConfigurationException {
                    ScrConfiguration.this.configure(properties);
                }
            };
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", "org.apache.felix.scr.ScrService");
            bundleContext.registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ScrConfiguration.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (Object)service, props);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void configure(Dictionary config) {
        if (config == null) {
            this.logLevel = ScrConfiguration.getLogLevel(this.bundleContext);
            this.factoryEnabled = VALUE_TRUE.equals(this.bundleContext.getProperty(PROP_FACTORY_ENABLED));
        } else {
            this.logLevel = (Integer)config.get(PROP_LOGLEVEL);
            this.factoryEnabled = (Boolean)config.get(PROP_FACTORY_ENABLED);
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean isFactoryEnabled() {
        return this.factoryEnabled;
    }

    private static int getLogLevel(BundleContext bundleContext) {
        block8: {
            String levelString = bundleContext.getProperty(PROP_LOGLEVEL);
            if (levelString != null) {
                try {
                    return Integer.parseInt(levelString);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LOG_LEVEL_DEBUG.equalsIgnoreCase(levelString)) {
                        return 4;
                    }
                    if (LOG_LEVEL_INFO.equalsIgnoreCase(levelString)) {
                        return 3;
                    }
                    if (LOG_LEVEL_WARN.equalsIgnoreCase(levelString)) {
                        return 2;
                    }
                    if (!LOG_LEVEL_ERROR.equalsIgnoreCase(levelString)) break block8;
                    return 1;
                }
            }
        }
        if (VALUE_TRUE.equalsIgnoreCase(bundleContext.getProperty(PROP_SHOWTRACE))) {
            return 4;
        }
        if ("false".equalsIgnoreCase(bundleContext.getProperty(PROP_SHOWERRORS))) {
            return -1;
        }
        return 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

