/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.scr.impl.helper.BaseMethod;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.osgi.framework.ServiceReference;

public class BindMethod
extends BaseMethod {
    private final String m_referenceName;
    private final String m_referenceClassName;

    public BindMethod(AbstractComponentManager componentManager, String methodName, Class componentClass, String referenceName, String referenceClassName) {
        super(componentManager, methodName, componentClass);
        this.m_referenceName = referenceName;
        this.m_referenceClassName = referenceClassName;
    }

    protected Method doFindMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        Method method;
        boolean suitableMethodNotAccessible = false;
        try {
            method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage);
            if (method != null) {
                return method;
            }
        }
        catch (SuitableMethodNotAccessibleException ex) {
            suitableMethodNotAccessible = true;
        }
        Class parameterClass = this.getParameterClass(targetClass);
        if (parameterClass != null) {
            try {
                method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            try {
                method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            if (this.isDS11()) {
                try {
                    method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
        }
        if (suitableMethodNotAccessible) {
            this.getComponentManager().log(1, "DependencyManager : Suitable but non-accessible method found in class {0}", new Object[]{targetClass.getName()}, null);
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Class getParameterClass(Class targetClass) {
        try {
            ClassLoader loader = targetClass.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            return loader.loadClass(this.m_referenceClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Method getServiceReferenceMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectAssignableMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Class<?> theParameter;
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1 || !method.getName().equals(this.getMethodName()) || !(theParameter = parameters[0]).isAssignableFrom(parameterClass)) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, MAP_CLASS}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 2 || !method.getName().equals(this.getMethodName()) || !parameters[0].isAssignableFrom(parameterClass) || parameters[1] != MAP_CLASS) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    protected Object[] getParameters(Method method, Object rawParameter) {
        Service service = (Service)rawParameter;
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < params.length; ++i) {
            if (paramTypes[i] == SERVICE_REFERENCE_CLASS) {
                params[i] = service.getReference();
                continue;
            }
            if (paramTypes[i] == MAP_CLASS) {
                params[i] = new ReadOnlyDictionary(service.getReference());
                continue;
            }
            params[i] = service.getInstance();
            if (params[i] != null) continue;
            throw new IllegalStateException("Dependency Manager: Service " + service.getReference() + " has already gone, will not " + this.getMethodNamePrefix());
        }
        return params;
    }

    protected String getMethodNamePrefix() {
        return "bind";
    }

    public static interface Service {
        public ServiceReference getReference();

        public Object getInstance();
    }
}

