/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;

public class InjectionManager {
    public void inject(Object component, InjectionResolver ... targets) {
        this.inject(component, null, component.getClass(), targets);
    }

    public void inject(Object component, Inhabitant<?> onBehalfOf, InjectionResolver ... targets) {
        this.inject(component, onBehalfOf, component.getClass(), targets);
    }

    public void inject(Object component, Class type, InjectionResolver ... targets) {
        this.inject(component, null, type, targets);
    }

    public void inject(Object component, Inhabitant<?> onBehalfOf, Class type, InjectionResolver ... targets) {
        try {
            assert (component != null);
            for (Class currentClass = type; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                Injectable injectable;
                Object value;
                Object inject;
                for (Field field : currentClass.getDeclaredFields()) {
                    for (InjectionResolver target : targets) {
                        inject = field.getAnnotation(target.type);
                        if (inject == null) continue;
                        Type genericType = field.getGenericType();
                        Class<?> fieldType = field.getType();
                        try {
                            value = target.getValue(component, onBehalfOf, field, genericType, fieldType);
                            if (value != null) {
                                field.setAccessible(true);
                                field.set(component, value);
                                try {
                                    injectable = (Injectable)Injectable.class.cast(value);
                                    if (injectable != null) {
                                        injectable.injectedInto(component);
                                    }
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            if (target.isOptional(field, inject)) continue;
                            throw new UnsatisfiedDependencyException(field);
                        }
                        catch (ComponentException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                    }
                }
                for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                    for (InjectionResolver target : targets) {
                        Class<?>[] paramTypes;
                        inject = ((Method)accessibleObject).getAnnotation(target.type);
                        if (inject == null) continue;
                        Method setter = target.getSetterMethod((Method)accessibleObject, inject);
                        if (setter.getReturnType() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(setter.getReturnType())) {
                                this.injectCollection(component, setter, target.getValue(component, onBehalfOf, accessibleObject, null, setter.getReturnType()));
                                continue;
                            }
                            this.error_InjectMethodIsNotVoid((Method)accessibleObject);
                        }
                        if (!this.allowInjection((Method)accessibleObject, paramTypes = setter.getParameterTypes())) continue;
                        try {
                            if (1 == paramTypes.length) {
                                value = target.getValue(component, onBehalfOf, accessibleObject, null, paramTypes[0]);
                                if (value != null) {
                                    setter.setAccessible(true);
                                    setter.invoke(component, value);
                                    try {
                                        injectable = (Injectable)Injectable.class.cast(value);
                                        if (injectable == null) continue;
                                        injectable.injectedInto(component);
                                    }
                                    catch (Exception e) {}
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject);
                            }
                            setter.setAccessible(true);
                            Type[] gparamType = setter.getGenericParameterTypes();
                            Object[] params = new Object[paramTypes.length];
                            for (int i = 0; i < paramTypes.length; ++i) {
                                Object value2 = target.getValue(component, onBehalfOf, accessibleObject, gparamType[i], paramTypes[i]);
                                if (value2 != null) {
                                    params[i] = value2;
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject);
                            }
                            setter.invoke(component, params);
                            for (Object value3 : params) {
                                try {
                                    Injectable injectable2 = (Injectable)Injectable.class.cast(value3);
                                    if (injectable2 == null) continue;
                                    injectable2.injectedInto(component);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (ComponentException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (InvocationTargetException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                    }
                }
            }
        }
        catch (LinkageError e) {
            Class cls = type;
            LinkageError x = new LinkageError("injection failed on " + cls + " from " + cls.getClassLoader());
            x.initCause(e);
            throw x;
        }
    }

    protected void error_injectionException(InjectionResolver target, Annotation inject, AnnotatedElement injectionPoint, Exception e) {
        Logger.getAnonymousLogger().log(Level.FINE, "injection failure", e);
        if (UnsatisfiedDependencyException.class.isInstance(e)) {
            if (injectionPoint == ((UnsatisfiedDependencyException)e).getUnsatisfiedElement()) {
                throw (UnsatisfiedDependencyException)e;
            }
            if (target.isOptional(injectionPoint, inject)) {
                return;
            }
            throw new UnsatisfiedDependencyException(injectionPoint, (Throwable)e);
        }
        throw new ComponentException(UnsatisfiedDependencyException.injection_failed_msg(injectionPoint, e), e);
    }

    protected boolean allowInjection(Method method, Class<?>[] paramTypes) {
        if (paramTypes.length > 1) {
            this.error_InjectMethodHasMultipleParams(method);
        }
        if (paramTypes.length == 0) {
            this.error_InjectMethodHasNoParams(method);
        }
        return true;
    }

    protected void error_InjectMethodHasMultipleParams(Method method) {
        throw new ComponentException("injection failed on %s : setter method takes more than 1 parameter", method.toGenericString());
    }

    protected void error_InjectMethodHasNoParams(Method method) {
        throw new ComponentException("injection failed on %s : setter method does not take a parameter", method.toGenericString());
    }

    protected void error_InjectMethodIsNotVoid(Method method) {
        throw new ComponentException("Injection failed on %s : setter method is not declared with a void return type", method.toGenericString());
    }

    private void injectCollection(Object component, Method method, Object value) {
        if (value == null) {
            return;
        }
        Collection c = (Collection)Collection.class.cast(value);
        Collection target = null;
        try {
            target = (Collection)Collection.class.cast(method.invoke(component, new Object[0]));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        target.addAll(c);
    }
}

