/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.glassfish.osgiweb.ContextPathCollisionException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.util.tracker.ServiceTracker;

class ContextPathCollisionDetector {
    private static ContextPathCollisionDetector _me = new ContextPathCollisionDetector();
    private static Logger logger = Logger.getLogger(ContextPathCollisionDetector.class.getPackage().getName());
    Map<String, List<Long>> contextPath2BundlesMap = new HashMap<String, List<Long>>();
    private ServiceTracker osgiContainerTracker = new ServiceTracker(this.getBundle().getBundleContext(), OSGiContainer.class.getName(), null);
    private boolean stopped;

    private ContextPathCollisionDetector() {
        this.osgiContainerTracker.open();
    }

    public static ContextPathCollisionDetector get() {
        return _me;
    }

    synchronized void stop() {
        this.osgiContainerTracker.close();
        this.stopped = true;
    }

    public synchronized void preDeploy(Bundle bundle) throws ContextPathCollisionException {
        if (this.stopped) {
            return;
        }
        String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
        List<Long> bundleIds = this.contextPath2BundlesMap.get(contextPath);
        if (bundleIds == null) {
            bundleIds = new ArrayList<Long>();
            this.contextPath2BundlesMap.put(contextPath, bundleIds);
        }
        if (!bundleIds.contains(bundle.getBundleId())) {
            bundleIds.add(bundle.getBundleId());
        }
        if (bundleIds.size() > 1) {
            throw new ContextPathCollisionException(contextPath, bundleIds.toArray(new Long[0]));
        }
    }

    public synchronized void postUndeploy(Bundle bundle) {
        if (this.stopped) {
            return;
        }
        String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
        List<Long> bundleIds = this.contextPath2BundlesMap.get(contextPath);
        assert (bundleIds != null && bundleIds.size() >= 1);
        if (bundleIds == null || bundleIds.isEmpty()) {
            return;
        }
        int idx = bundleIds.indexOf(bundle.getBundleId());
        assert (idx != -1);
        if (idx == -1) {
            return;
        }
        bundleIds.remove(idx);
        if (bundleIds.isEmpty()) {
            return;
        }
        logger.logp(Level.INFO, "CollisionDetector", "postUndeploy", "Attempting to deploy bundle {0} with context path {1} ", new Object[]{bundleIds.get(idx), contextPath});
        Collections.sort(bundleIds);
        try {
            this.getOSGiContainer().deploy(this.getBundle().getBundleContext().getBundle(bundleIds.get(0).longValue()));
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "CollisionDetector", "postUndeploy", "e = {0}", new Object[]{e});
        }
    }

    private OSGiContainer getOSGiContainer() {
        return (OSGiContainer)this.osgiContainerTracker.getService();
    }

    private Bundle getBundle() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle();
    }

    public synchronized void cleanUp(Bundle bundle) {
        String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
        List<Long> bundleIds = this.contextPath2BundlesMap.get(contextPath);
        assert (bundleIds != null && bundleIds.size() >= 1);
        if (bundleIds == null || bundleIds.isEmpty()) {
            return;
        }
        int idx = bundleIds.indexOf(bundle.getBundleId());
        assert (idx != -1);
        if (idx == -1) {
            return;
        }
        Long bundleId = bundleIds.remove(idx);
        logger.logp(Level.INFO, "CollisionDetector", "cleanUp", "Removed bundle {0} against context path {1} ", new Object[]{bundleId, contextPath});
    }
}

