/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.spi.distributed;

import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.spi.distributed.DistributedEJBServiceFactory;
import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanNotifier;
import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanService;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class ReadOnlyBeanMessageCallBack
implements CallBack,
DistributedReadOnlyBeanNotifier {
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    GMSAdapterService gmsAdapterService;
    private static DistributedReadOnlyBeanService _readOnlyBeanService = DistributedEJBServiceFactory.getDistributedEJBService().getDistributedReadOnlyBeanService();
    private GroupManagementService gms;
    private static final String GMS_READ_ONLY_COMPONENT_NAME = "__GMS__READ_ONLY_BEAN__";

    public void postConstruct() {
        GMSAdapter gmsAdapter;
        if (!this.ejbContainerUtil.isDas() && this.gmsAdapterService != null && (gmsAdapter = this.gmsAdapterService.getGMSAdapter()) != null) {
            this.gms = gmsAdapter.getModule();
            gmsAdapter.registerMessageListener(GMS_READ_ONLY_COMPONENT_NAME, (CallBack)this);
            _readOnlyBeanService.setDistributedReadOnlyBeanNotifier(this);
        }
    }

    public void processNotification(Signal signal) {
        Logger _logger = this.ejbContainerUtil.getLogger();
        try {
            MessageSignal messageSignal = (MessageSignal)signal;
            byte[] payload = messageSignal.getMessage();
            int size = payload.length;
            long ejbID = ReadOnlyBeanMessageCallBack.bytesToLong(payload, 0);
            if (size == 8) {
                _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack:  Got message for ejbID: " + ejbID);
                _readOnlyBeanService.handleRefreshAllRequest(ejbID);
            } else {
                byte[] pkData = new byte[size - 8];
                System.arraycopy(payload, 8, pkData, 0, pkData.length);
                _readOnlyBeanService.handleRefreshRequest(ejbID, pkData);
                _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack:  Handled message for ejbID: " + ejbID);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack: Got exception while handling message", ex);
        }
    }

    public void notifyRefresh(long ejbID, byte[] pk) {
        int size = pk.length;
        byte[] payload = new byte[size + 8];
        Logger _logger = this.ejbContainerUtil.getLogger();
        ReadOnlyBeanMessageCallBack.longToBytes(ejbID, payload, 0);
        System.arraycopy(pk, 0, payload, 8, size);
        try {
            this.gms.getGroupHandle().sendMessage(GMS_READ_ONLY_COMPONENT_NAME, payload);
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack:  Sent message for ejbID: " + ejbID);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack: Got exception during notifyRefresh", ex);
        }
    }

    public void notifyRefreshAll(long ejbID) {
        byte[] payload = new byte[8];
        Logger _logger = this.ejbContainerUtil.getLogger();
        ReadOnlyBeanMessageCallBack.longToBytes(ejbID, payload, 0);
        try {
            this.gms.getGroupHandle().sendMessage(GMS_READ_ONLY_COMPONENT_NAME, payload);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack: Got exception during notifyRefreshAll", ex);
        }
    }

    private static void longToBytes(long value, byte[] array, int offset) {
        array[offset] = (byte)(value >>> 56 & 0xFFL);
        array[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        array[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        array[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        array[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        array[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        array[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        array[offset + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    private static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)ReadOnlyBeanMessageCallBack.bytesToInt(array, offset) << 32;
        long l2 = (long)ReadOnlyBeanMessageCallBack.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    private static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset] << 24 & 0xFF000000;
        int b2 = array[offset + 1] << 16 & 0xFF0000;
        int b3 = array[offset + 2] << 8 & 0xFF00;
        int b4 = array[offset + 3] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }
}

