/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login.common;

import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.common.AppservAccessController;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import org.glassfish.security.common.Group;

public class ServerLoginCallbackHandler
implements CallbackHandler {
    private String username = null;
    private String password = null;
    private String moduleID = null;

    public ServerLoginCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public ServerLoginCallbackHandler(String username, String password, String moduleID) {
        this.username = username;
        this.password = password;
        this.moduleID = moduleID;
    }

    public ServerLoginCallbackHandler() {
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setModuleID(String moduleID) {
        this.moduleID = moduleID;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nme = (NameCallback)callbacks[i];
                nme.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pswd = (PasswordCallback)callbacks[i];
                pswd.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof CertificateRealm.AppContextCallback) {
                ((CertificateRealm.AppContextCallback)callbacks[i]).setModuleID(this.moduleID);
                continue;
            }
            if (callbacks[i] instanceof GroupPrincipalCallback) {
                this.processGroupPricipal((GroupPrincipalCallback)callbacks[i]);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private void processGroupPricipal(GroupPrincipalCallback gpCallback) {
        final Subject fs = gpCallback.getSubject();
        final String[] groups = gpCallback.getGroups();
        if (groups != null && groups.length > 0) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (String group : groups) {
                        fs.getPrincipals().add((Principal)new Group(group));
                    }
                    return fs;
                }
            });
        } else if (groups == null) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<Principal> principalSet = fs.getPrincipals();
                    principalSet.removeAll(fs.getPrincipals(Group.class));
                    return fs;
                }
            });
        }
    }
}

