/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.nonce;

import com.sun.enterprise.security.auth.nonce.Nonce;
import com.sun.enterprise.security.auth.nonce.NonceManager;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonceCache
extends TimerTask {
    private static final Logger logger = LogDomains.getLogger(NonceCache.class, (String)"javax.enterprise.system.core.security");
    public static final long MAX_NONCE_AGE = 900000L;
    private Hashtable<Nonce, String> nonceCache = new Hashtable();
    private Hashtable<Nonce, String> oldNonceCache = new Hashtable();
    private long maxNonceAge = 900000L;
    private boolean scheduledFlag = false;
    private boolean canceledFlag = false;

    public NonceCache() {
    }

    public NonceCache(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public void run() {
        if (this.nonceCache.size() == 0) {
            this.cancel();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Canceled Timer Task due to inactivity ...for " + this);
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Clearing old Nonce values...for " + this);
        }
        this.oldNonceCache.clear();
        Hashtable<Nonce, String> temp = this.nonceCache;
        this.nonceCache = this.oldNonceCache;
        this.oldNonceCache = temp;
    }

    public boolean validateAndCacheNonce(Nonce nonce, String created) throws NonceManager.NonceException {
        if (this.nonceCache.containsKey(nonce) || this.oldNonceCache.containsKey(nonce)) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Storing Nonce Value " + nonce + " into " + this);
        }
        this.nonceCache.put(nonce, created);
        return true;
    }

    public boolean hasNonce(Nonce nonce) {
        return this.nonceCache.containsKey(nonce) || this.oldNonceCache.containsKey(nonce);
    }

    public boolean isScheduled() {
        return this.scheduledFlag;
    }

    public void scheduled(boolean flag) {
        this.scheduledFlag = flag;
    }

    public boolean wasCanceled() {
        return this.canceledFlag;
    }

    public boolean cancel() {
        boolean ret = super.cancel();
        this.canceledFlag = true;
        this.oldNonceCache.clear();
        this.nonceCache.clear();
        return ret;
    }

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }
}

