/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CreateFileUser;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="delete-file-user")
@Scoped(value=PerLookup.class)
@I18n(value="delete.file.user")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteFileUser
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteFileUser.class);
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Param(name="username", primary=true)
    private String userName;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        SecurityService securityService = this.config.getSecurityService();
        if (this.authRealmName == null) {
            this.authRealmName = securityService.getDefaultRealm();
        }
        AuthRealm fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(this.authRealmName)) continue;
            fileAuthRealm = authRealm;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("delete.file.user.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("delete.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        final String kFile = keyFile;
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("delete.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean exists = new File(kFile).exists();
        if (!exists) {
            report.setMessage(localStrings.getLocalString("file.realm.keyfilenonexistent", "The specified physical file {0} associated with the file realm {1} does not exist.", new Object[]{kFile, this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    try {
                        DeleteFileUser.this.realmsManager.createRealms(DeleteFileUser.this.config);
                        FileRealm fr = (FileRealm)DeleteFileUser.this.realmsManager.getFromLoadedRealms(DeleteFileUser.this.config.getName(), DeleteFileUser.this.authRealmName);
                        fr.removeUser(DeleteFileUser.this.userName);
                        if (Util.isEmbeddedServer()) {
                            fr.writeKeyFile(Util.writeConfigFileToTempDir(kFile).getAbsolutePath());
                        } else {
                            fr.writeKeyFile(kFile);
                        }
                        CreateFileUser.refreshRealm(DeleteFileUser.this.config.getName(), DeleteFileUser.this.authRealmName);
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    }
                    catch (NoSuchUserException e) {
                        report.setMessage(localStrings.getLocalString("delete.file.user.usernotfound", "There is no such existing user {0} in the file realm {1}.", new Object[]{DeleteFileUser.this.userName, DeleteFileUser.this.authRealmName}) + "  " + e.getLocalizedMessage());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    catch (BadRealmException e) {
                        report.setMessage(localStrings.getLocalString("delete.file.user.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{DeleteFileUser.this.authRealmName}) + "  " + e.getLocalizedMessage());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        report.setMessage(localStrings.getLocalString("delete.file.user.userdeletefailed", "Removing User {0} from file realm {1} failed", new Object[]{DeleteFileUser.this.userName, DeleteFileUser.this.authRealmName}) + "  " + e.getLocalizedMessage());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)securityService);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.file.user.userdeletefailed", "Removing User {0} from file realm {1} failed", new Object[]{this.userName, this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

