/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;

@Service(name="_lifecycle")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.INSTANCE})
public class InstanceLifecycleModuleCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InstanceLifecycleModuleCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(separator=58)
    public Properties appprops = null;
    @Inject
    Deployment deployment;
    @Inject
    Applications applications;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        try {
            Application application = this.applications.getApplication(this.name);
            Transaction t = new Transaction();
            DeployCommandParameters commandParams = new DeployCommandParameters();
            commandParams.name = this.name;
            commandParams.target = this.target;
            commandParams.enabled = this.enabled;
            commandParams.virtualservers = this.virtualservers;
            DeploymentContextImpl lifecycleContext = new DeploymentContextImpl(report, logger, null, (OpsParams)commandParams, null);
            lifecycleContext.getAppProps().putAll((Map<?, ?>)this.appprops);
            if (application != null) {
                this.deployment.registerAppInDomainXML(null, (DeploymentContext)lifecycleContext, t, true);
            } else {
                t = this.deployment.prepareAppConfigChanges((DeploymentContext)lifecycleContext);
                this.deployment.registerAppInDomainXML(null, (DeploymentContext)lifecycleContext, t);
            }
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
    }
}

