/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijdbc;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijdbc.DataSourceFactoryImpl;
import org.glassfish.osgijdbc.JDBCDriverURLStreamHandlerService;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class JDBCExtender
implements Extender {
    private BundleContext bundleContext;
    private ServiceRegistration urlHandlerService;
    private Set<DataSourceFactoryImpl> dataSourceFactories = new HashSet<DataSourceFactoryImpl>();
    private Habitat habitat;
    private BundleTracker bundleTracker;
    private static final Logger logger = Logger.getLogger(JDBCExtender.class.getPackage().getName());

    public JDBCExtender(BundleContext context) {
        this.bundleContext = context;
    }

    public void start() {
        this.debug("begin start()");
        this.habitat = Globals.getDefaultHabitat();
        this.bundleTracker = new BundleTracker(this.bundleContext, 32, (BundleTrackerCustomizer)new JDBCBundleTrackerCustomizer());
        this.bundleTracker.open();
        this.addURLHandler();
        this.debug("completed start()");
    }

    public void stop() {
        this.removeURLHandler();
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
        for (DataSourceFactoryImpl dsfi : this.dataSourceFactories) {
            dsfi.preDestroy();
        }
        this.debug("stopped");
    }

    private Habitat getHabitat() {
        return this.habitat;
    }

    private void addURLHandler() {
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)this.getHabitat().getByContract(ClassLoaderHierarchy.class);
        ClassLoader apiClassLoader = clh.getAPIClassLoader();
        Properties p = new Properties();
        p.put("url.handler.protocol", new String[]{"jdbcdriver"});
        this.urlHandlerService = this.bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new JDBCDriverURLStreamHandlerService(apiClassLoader), (Dictionary)p);
    }

    private void removeURLHandler() {
        if (this.urlHandlerService != null) {
            this.urlHandlerService.unregister();
            this.urlHandlerService = null;
        }
    }

    private boolean isJdbcDriverBundle(Bundle b) {
        String osgiRFC = (String)b.getHeaders().get("OSGI_RFC_122");
        return osgiRFC != null && Boolean.valueOf(osgiRFC) != false;
    }

    private void debug(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[osgi-jdbc] : " + s);
        }
    }

    private class JDBCBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private JDBCBundleTrackerCustomizer() {
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            if (JDBCExtender.this.isJdbcDriverBundle(bundle)) {
                String implTitle;
                JDBCExtender.this.debug("Starting JDBC Bundle : " + bundle.getSymbolicName());
                DataSourceFactoryImpl dsfi = new DataSourceFactoryImpl(bundle.getBundleContext());
                JDBCExtender.this.dataSourceFactories.add(dsfi);
                Properties serviceProperties = new Properties();
                Dictionary header = bundle.getHeaders();
                serviceProperties.put("osgi.jdbc.driver.class", header.get("java.sql.Driver".replace(".", "_")));
                String implVersion = (String)header.get("Implementation-Version");
                if (implVersion != null) {
                    serviceProperties.put("osgi.jdbc.driver.version", implVersion);
                }
                if ((implTitle = (String)header.get("Implementation-Title")) != null) {
                    serviceProperties.put("osgi.jdbc.driver.name", implTitle);
                }
                JDBCExtender.this.debug(" registering service for driver [" + header.get("java.sql.Driver".replace(".", "_")) + "]");
                bundle.getBundleContext().registerService(DataSourceFactory.class.getName(), (Object)dsfi, (Dictionary)serviceProperties);
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        }
    }
}

