/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.common.DoNothingActionReporter;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.SystemTasks;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.Init;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Priority;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AppServerStartup
implements ModuleStartup {
    StartupContext context;
    static final Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry systemRegistry;
    @Inject
    ExecutorService executor;
    @Inject
    Events events;
    @Inject
    Version version;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    @Inject
    SystemTasks pidWriter;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    private Thread serverThread;

    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    public synchronized void start() {
        Thread.currentThread().setContextClassLoader(this.commonCLS.getCommonClassLoader());
        this.run();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverThread = new Thread("GlassFish Kernel Main Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.logp(Level.FINE, "AppServerStartup", "run", "[{0}] started", new Object[]{this});
                latch.countDown();
                try {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                logger.logp(Level.INFO, "AppServerStartup", "run", "[{0}] exiting", new Object[]{this});
            }
        };
        this.serverThread.setDaemon(false);
        this.serverThread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void run() {
        String platform = System.getProperty("GlassFish_Platform");
        if (platform == null) {
            platform = "Embedded";
        }
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
            return;
        }
        long platformInitTime = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Startup class : " + this.getClass().getName());
        }
        Level level = Level.FINE;
        this.habitat.addComponent(null, (Object)this);
        this.habitat.addComponent(null, (Object)this.systemRegistry);
        this.habitat.addComponent("javax.enterprise.system.core", (Object)logger);
        Inhabitant inh = this.habitat.getInhabitantByType(ProcessEnvironment.class);
        if (inh != null) {
            this.habitat.remove(inh);
        }
        this.habitat.removeAllByType(ProcessEnvironment.class);
        if (this.env.isEmbedded()) {
            this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(ProcessEnvironment.class, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Embedded)));
        } else {
            this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(ProcessEnvironment.class, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Server)));
        }
        HashMap<Class, Long> servicesTiming = new HashMap<Class, Long>();
        for (Inhabitant init : this.habitat.getInhabitants(Init.class)) {
            long start = System.currentTimeMillis();
            init.get();
            if (logger.isLoggable(level)) {
                logger.log(level, init.type() + " Init done in " + (System.currentTimeMillis() - this.context.getCreationTime()) + " ms");
            }
            if (!logger.isLoggable(level)) continue;
            servicesTiming.put(init.type(), System.currentTimeMillis() - start);
        }
        Collection startups = this.habitat.getInhabitants(Startup.class);
        PriorityQueue startupSvcs = new PriorityQueue(startups.size(), this.getInhabitantComparator());
        startupSvcs.addAll(startups);
        boolean shutdownRequested = false;
        ArrayList futures = new ArrayList();
        while (!startupSvcs.isEmpty()) {
            Inhabitant<?> i = startupSvcs.poll();
            if (i.type().getAnnotation(Async.class) != null) continue;
            long l = System.currentTimeMillis();
            try {
                if (logger.isLoggable(level)) {
                    logger.log(level, "Running Startup services " + i.type());
                }
                Startup startup = (Startup)i.get();
                if (logger.isLoggable(level)) {
                    logger.log(level, "Startup services finished" + startup);
                }
                if (startup instanceof FutureProvider) {
                    futures.addAll(((FutureProvider)((Object)startup)).getFutures());
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                logger.log(Level.SEVERE, localStrings.getLocalString("startupservicefailure", "Startup service failed to start : {0} ", new Object[]{i.typeName()}), e.getMessage());
            }
            if (!logger.isLoggable(level)) continue;
            servicesTiming.put(i.type(), System.currentTimeMillis() - l);
        }
        this.env.setStatus(ServerEnvironment.Status.starting);
        this.events.send(new EventListener.Event(EventTypes.SERVER_STARTUP), false);
        Object[] objectArray = new Object[6];
        AppServerStartup appServerStartup = this;
        objectArray[0] = appServerStartup.version.getVersion();
        AppServerStartup appServerStartup2 = this;
        objectArray[1] = appServerStartup2.version.getBuildVersion();
        objectArray[2] = platform;
        objectArray[3] = platformInitTime - this.context.getCreationTime();
        objectArray[4] = System.currentTimeMillis() - platformInitTime;
        objectArray[5] = System.currentTimeMillis() - this.context.getCreationTime();
        logger.info(localStrings.getLocalString("startup_end_message", "{0} ({1}) startup time : {2} ({3}ms), startup services({4}ms), total({5}ms)", objectArray));
        AppServerStartup.printModuleStatus(this.systemRegistry, level);
        try {
            long realstart = Long.parseLong(System.getProperty("WALL_CLOCK_START"));
            logger.info("TOTAL TIME INCLUDING CLI: " + (System.currentTimeMillis() - realstart));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (logger.isLoggable(level)) {
            for (Map.Entry entry : servicesTiming.entrySet()) {
                logger.info("Service : " + entry.getKey() + " took " + entry.getValue() + " ms");
            }
        }
        if (shutdownRequested) {
            this.shutdown();
        } else {
            for (Future future : futures) {
                try {
                    try {
                        if (!((Result)future.get(3L, TimeUnit.SECONDS)).isFailure()) continue;
                        Throwable t = ((Result)future.get()).exception();
                        logger.log(Level.SEVERE, localStrings.getLocalString("startupfatalstartup", "Shutting down v3 due to startup exception : ", new Object[]{t.getMessage()}));
                        logger.log(Level.FINE, ((Result)future.get()).exception().getMessage(), t);
                        this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN));
                        this.shutdown();
                        return;
                    }
                    catch (TimeoutException e) {
                        logger.warning(localStrings.getLocalString("startupwaittimeout", "Timed out, ignoring some startup service status"));
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }
        this.env.setStatus(ServerEnvironment.Status.started);
        this.events.send(new EventListener.Event(EventTypes.SERVER_READY), false);
        this.pidWriter.writePidFile();
        for (Inhabitant inhabitant : this.habitat.getInhabitants(PostStartup.class)) {
            inhabitant.get();
        }
        AppServerStartup.printModuleStatus(this.systemRegistry, level);
    }

    public static void printModuleStatus(ModulesRegistry registry, Level level) {
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder("Module Status Report Begins\n");
        for (Module m : registry.getModules()) {
            if (m.getState() != ModuleState.READY) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (Module m : registry.getModules()) {
            if (m.getState() != ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (Module m : registry.getModules()) {
            if (m.getState() == ModuleState.READY || m.getState() == ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("Module Status Report Ends");
        logger.log(level, sb.toString());
    }

    private void shutdown() {
        CommandRunner runner = (CommandRunner)this.habitat.getByContract(CommandRunner.class);
        if (runner != null) {
            ParameterMap params = new ParameterMap();
            if (this.context.getArguments().containsKey("--noforcedshutdown")) {
                params.set("force", "false");
            }
            if (this.env.isDas()) {
                runner.getCommandInvocation("stop-domain", new DoNothingActionReporter()).parameters(params).execute();
            } else {
                runner.getCommandInvocation("_stop-instance", new DoNothingActionReporter()).parameters(params).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.env.getStatus() != ServerEnvironment.Status.started) {
            logger.info("Already stopped, so just returning");
            return;
        }
        this.env.setStatus(ServerEnvironment.Status.stopping);
        this.events.send(new EventListener.Event(EventTypes.PREPARE_SHUTDOWN), false);
        try {
            Collection startups = this.habitat.getInhabitants(Startup.class);
            Collection postStartups = this.habitat.getInhabitants(PostStartup.class);
            PriorityQueue mergedStartup = new PriorityQueue(startups.size() + postStartups.size(), this.getInhabitantComparator());
            mergedStartup.addAll(postStartups);
            mergedStartup.addAll(startups);
            ArrayList services = new ArrayList();
            while (!mergedStartup.isEmpty()) {
                services.add(mergedStartup.poll());
            }
            Collections.reverse(services);
            for (Inhabitant inhabitant : services) {
                if (!inhabitant.isInstantiated()) continue;
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Releasing services " + inhabitant.type());
                    }
                    inhabitant.release();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.env.setStatus(ServerEnvironment.Status.stopped);
            this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
            logger.info(localStrings.getLocalString("shutdownfinished", "Shutdown procedure finished"));
            for (Inhabitant inhabitant : this.habitat.getInhabitants(Init.class)) {
                if (!inhabitant.isInstantiated()) continue;
                try {
                    inhabitant.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ComponentException e) {
            // empty catch block
        }
        if (this.serverThread != null) {
            Thread e = this.serverThread;
            synchronized (e) {
                this.serverThread.notify();
            }
            try {
                this.serverThread.join(0L);
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private Comparator<Inhabitant<?>> getInhabitantComparator() {
        return new Comparator<Inhabitant<?>>(){

            @Override
            public int compare(Inhabitant<?> o1, Inhabitant<?> o2) {
                int o2level;
                int o1level = o1.type().getAnnotation(Priority.class) != null ? o1.type().getAnnotation(Priority.class).value() : 5;
                int n = o2level = o2.type().getAnnotation(Priority.class) != null ? o2.type().getAnnotation(Priority.class).value() : 5;
                if (o1level == o2level) {
                    return 0;
                }
                if (o1level < o2level) {
                    return -1;
                }
                return 1;
            }
        };
    }
}

