/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.enterprise.module.common_impl.Tokenizer;
import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.AppLibClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassLoaderService;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.TranslationException;
import org.jvnet.hk2.config.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ClassLoaderHierarchyImpl
implements ClassLoaderHierarchy {
    @Inject
    APIClassLoaderServiceImpl apiCLS;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    @Inject(optional=true)
    ConnectorClassLoaderService connectorCLS;
    @Inject
    AppLibClassLoaderServiceImpl applibCLS;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    SystemVariableResolver resolver = new SystemVariableResolver();

    public ClassLoader getAPIClassLoader() {
        return this.apiCLS.getAPIClassLoader();
    }

    public ClassLoader getCommonClassLoader() {
        return this.commonCLS.getCommonClassLoader();
    }

    public String getCommonClassPath() {
        return this.commonCLS.getCommonClassPath();
    }

    public DelegatingClassLoader getConnectorClassLoader(String application) {
        if (this.connectorCLS != null) {
            return this.connectorCLS.getConnectorClassLoader(application);
        }
        return new DelegatingClassLoader(this.commonCLS.getCommonClassLoader());
    }

    public ClassLoader getAppLibClassLoader(String application, List<URI> libURIs) throws MalformedURLException {
        return this.applibCLS.getAppLibClassLoader(application, libURIs);
    }

    public DelegatingClassLoader.ClassFinder getAppLibClassFinder(List<URI> libURIs) throws MalformedURLException {
        return this.applibCLS.getAppLibClassFinder(libURIs);
    }

    public ClassLoader createApplicationParentCL(ClassLoader parent, DeploymentContext context) throws ResolveError {
        Manifest m;
        ArrayList<ModuleDefinition> defs;
        block13: {
            ReadableArchive source = context.getSource();
            defs = new ArrayList<ModuleDefinition>();
            m = null;
            try {
                m = source.getManifest();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot load application's manifest file :", e.getMessage());
                if (!this.logger.isLoggable(Level.FINE)) break block13;
                this.logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (m != null) {
            String requestedWiring;
            String additionalRepo;
            String importedBundles = m.getMainAttributes().getValue("HK2-Import-Bundles");
            if (importedBundles != null) {
                for (String token : new Tokenizer(importedBundles, ",")) {
                    Collection modules = this.modulesRegistry.getModules(token);
                    if (modules.size() == 1) {
                        defs.add(((Module)modules.iterator().next()).getModuleDefinition());
                        continue;
                    }
                    throw new ResolveError("Not able to locate a unique module by name " + token);
                }
            }
            if ((additionalRepo = m.getMainAttributes().getValue("GlassFish-require-repository")) != null) {
                for (String token : new Tokenizer(additionalRepo, ",")) {
                    int equals = token.indexOf(61);
                    if (equals == -1) {
                        throw new IllegalArgumentException("\"GlassFish-require-repository: " + additionalRepo + "\" is missing an '='.  " + "It must be in the format: name=path[,name=path]...");
                    }
                    String name = token.substring(0, equals);
                    String path = token.substring(++equals);
                    this.addRepository(name, this.resolver.translate(path));
                }
            }
            if ((requestedWiring = m.getMainAttributes().getValue("GlassFish-require-services")) != null) {
                for (String token : new Tokenizer(requestedWiring, ",")) {
                    for (Inhabitant impl : this.habitat.getInhabitantsByContract(token)) {
                        Module wiredBundle = this.modulesRegistry.find(impl.get().getClass());
                        if (wiredBundle == null) continue;
                        defs.add(wiredBundle.getModuleDefinition());
                    }
                }
            }
        }
        if (defs.isEmpty()) {
            return parent;
        }
        return this.modulesRegistry.getModulesClassLoader(parent, defs);
    }

    private void addRepository(String name, String path) {
        File pathFile = new File(path);
        DirectoryBasedRepository repo = new DirectoryBasedRepository(name, pathFile);
        this.modulesRegistry.addRepository((Repository)repo);
        try {
            repo.initialize();
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Problem initializing additional repository!", ex);
        }
    }

    private static class SystemVariableResolver
    extends VariableResolver {
        SystemVariableResolver() {
        }

        protected String getVariableValue(String varName) throws TranslationException {
            String result = null;
            String value = System.getProperty(varName);
            result = value != null ? "" + value : "${" + varName + "}";
            return result;
        }

        public static boolean needsResolving(String value) {
            return value != null && value.indexOf("${") != -1;
        }

        public String resolve(String value) throws TranslationException {
            String result = this.translate(value);
            return result;
        }
    }
}

