/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class JarResourceExtractor {
    static Logger _logger = LogDomains.getLogger(JarResourceExtractor.class, (String)"javax.enterprise.resource.resourceadapter");
    private Hashtable htJarContents = new Hashtable();

    public JarResourceExtractor(String jarFileName) {
        this.init(jarFileName);
    }

    public byte[] getResource(String name) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("getResource: " + name);
        }
        return (byte[])this.htJarContents.get(name);
    }

    private void init(String jarFileName) {
        try {
            FileInputStream fis = new FileInputStream(jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            this.extractResources(zis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void extractResources(ZipInputStream zis) throws FileNotFoundException, IOException {
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("ExtractResources : " + ze.getName());
            }
            this.extractZipEntryContents(ze, zis);
        }
    }

    private void extractZipEntryContents(ZipEntry ze, ZipInputStream zis) throws IOException {
        if (ze.isDirectory()) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
        }
        byte[] b = this.getZipEntryContents(ze, zis);
        if (ze.getName().trim().endsWith(".jar")) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("JAR - going into it !!");
            }
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(b));
            this.extractResources(new ZipInputStream(bis));
        } else {
            this.htJarContents.put(ze.getName(), b);
            if (ze.getName().trim().endsWith("class") && _logger.isLoggable(Level.FINER)) {
                _logger.finer("CLASS added " + ze.getName());
            }
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(ze.getName() + ",size=" + b.length + ",csize=" + ze.getCompressedSize());
            }
        }
    }

    private byte[] getZipEntryContents(ZipEntry ze, ZipInputStream zis) throws IOException {
        int size = (int)ze.getSize();
        byte[] b = null;
        if (size != -1) {
            b = new byte[size];
            int rb = 0;
            int chunk = 0;
            while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                rb += chunk;
            }
        } else {
            ArrayList<Byte> al = new ArrayList<Byte>();
            int c = 0;
            while ((c = zis.read()) != -1) {
                al.add((byte)c);
            }
            Byte[] btArr = al.toArray(new Byte[0]);
            b = new byte[btArr.length];
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("ByteArray length" + btArr.length);
            }
            for (int i = 0; i < btArr.length; ++i) {
                b[i] = btArr[i];
            }
        }
        return b;
    }
}

