/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.waitqueue;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.pool.waitqueue.DefaultPoolWaitQueue;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueue;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoolWaitQueueFactory {
    private static final Logger _logger = LogDomains.getLogger(PoolWaitQueueFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    public static PoolWaitQueue createPoolWaitQueue(String className) throws PoolingException {
        PoolWaitQueue waitQueue;
        if (className != null) {
            waitQueue = PoolWaitQueueFactory.initializeCustomWaitQueueInPrivilegedMode(className);
        } else {
            waitQueue = new DefaultPoolWaitQueue();
            PoolWaitQueueFactory.debug("Initializing Default Pool Wait Queue");
        }
        return waitQueue;
    }

    private static PoolWaitQueue initializeCustomWaitQueueInPrivilegedMode(final String className) throws PoolingException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PoolWaitQueue result = null;
                try {
                    result = PoolWaitQueueFactory.initializeCustomWaitQueue(className);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "pool.waitqueue.init.failure", className);
                    _logger.log(Level.WARNING, "pool.waitqueue.init.failure.exception", e);
                }
                return result;
            }
        });
        if (result != null) {
            return (PoolWaitQueue)result;
        }
        throw new PoolingException("Unable to initalize custom PoolWaitQueue : " + className);
    }

    private static PoolWaitQueue initializeCustomWaitQueue(String className) throws Exception {
        Class<?> class1 = Thread.currentThread().getContextClassLoader().loadClass(className);
        PoolWaitQueue waitQueue = (PoolWaitQueue)class1.newInstance();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Using Pool Wait Queue class : ", className);
        }
        return waitQueue;
    }

    private static void debug(String debugStatement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, debugStatement);
        }
    }
}

