/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.logging.LogDomains;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public abstract class ConnectionHolder
implements Connection {
    protected Connection con;
    protected ManagedConnection mc;
    protected boolean wrappedAlready = false;
    protected boolean isClosed = false;
    protected boolean valid = true;
    protected boolean active = false;
    private LazyAssociatableConnectionManager lazyAssocCm_;
    private LazyEnlistableConnectionManager lazyEnlistCm_;
    private ConnectionRequestInfo cxReqInfo_;
    private ManagedConnectionFactory mcf_;
    protected int statementTimeout;
    protected boolean statementTimeoutEnabled;
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnection.class, (String)"javax.enterprise.resource.resourceadapter");
    private ConnectionType myType_ = ConnectionType.STANDARD;
    protected static final StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public ConnectionHolder(Connection con, ManagedConnection mc, ConnectionRequestInfo cxRequestInfo) {
        this.con = con;
        this.mc = mc;
        this.mcf_ = mc.getMcf();
        this.cxReqInfo_ = cxRequestInfo;
        this.statementTimeout = mc.getStatementTimeout();
        if (this.statementTimeout > 0) {
            this.statementTimeoutEnabled = true;
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    public void wrapped(boolean wrapFlag) {
        this.wrappedAlready = wrapFlag;
    }

    public boolean isWrapped() {
        return this.wrappedAlready;
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    public void associateConnection(Connection con, ManagedConnection mc) {
        this.mc = mc;
        this.con = con;
    }

    public void dissociateConnection() {
        this.mc = null;
        this.con = null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkValidity();
        this.con.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.duplicate_close_connection", this);
            }
            return;
        }
        this.isClosed = true;
        if (this.mc != null) {
            this.mc.connectionClosed(null, this);
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    void actualClose() throws SQLException {
        this.con.close();
    }

    @Override
    public void commit() throws SQLException {
        this.checkValidity();
        this.con.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        Statement stmt = this.con.createStatement();
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        Statement stmt = this.con.createStatement(resultSetType, resultSetConcurrency);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        Statement stmt = this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkValidity();
        return this.con.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValidity();
        return this.con.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkValidity();
        return this.con.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return this.con.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkValidity();
        return this.con.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkValidity();
        return this.con.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkValidity();
        return this.con.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkValidity();
        return this.con.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkValidity();
        return this.con.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        CallableStatement stmt = this.con.prepareCall(sql);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        CallableStatement stmt = this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        CallableStatement stmt = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement stmt = this.con.prepareStatement(sql);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement stmt = this.con.prepareStatement(sql, autoGeneratedKeys);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement stmt = this.con.prepareStatement(sql, columnIndexes);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement stmt = this.con.prepareStatement(sql, columnNames);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkValidity();
        this.con.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.con.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        this.con.setAutoCommit(autoCommit);
        this.mc.setLastAutoCommitValue(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
        this.con.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkValidity();
        this.con.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkValidity();
        this.con.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkValidity();
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkValidity();
        return this.con.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkValidity();
        this.con.setTransactionIsolation(level);
        this.mc.setLastTransactionIsolationLevel(level);
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection closed");
        }
        if (!this.valid) {
            throw new SQLException("Invalid Connection");
        }
        if (!this.active) {
            this.mc.checkIfActive(this);
        }
    }

    public void setActive(boolean actv) {
        this.active = actv;
    }

    protected void jdbcPreInvoke() throws SQLException {
        if (this.myType_ == ConnectionType.LAZY_ASSOCIATABLE) {
            this.performLazyAssociation();
        } else if (this.myType_ == ConnectionType.LAZY_ENLISTABLE) {
            this.performLazyEnlistment();
        }
    }

    protected void performLazyEnlistment() throws SQLException {
        try {
            this.lazyEnlistCm_.lazyEnlist((javax.resource.spi.ManagedConnection)this.mc);
        }
        catch (ResourceException re) {
            String msg = sm.getString("jdbc.cannot_enlist", (Object)(re.getMessage() + " Cannnot Enlist ManagedConnection"));
            SQLException sqle = new SQLException(msg);
            sqle.initCause(re);
            throw sqle;
        }
    }

    protected void performLazyAssociation() throws SQLException {
        if (this.mc == null) {
            try {
                this.lazyAssocCm_.associateConnection((Object)this, this.mcf_, this.cxReqInfo_);
            }
            catch (ResourceException re) {
                String msg = sm.getString("jdbc.cannot_assoc", (Object)(re.getMessage() + " Cannnot Associate ManagedConnection"));
                SQLException sqle = new SQLException(msg);
                sqle.initCause(re);
                throw sqle;
            }
        }
    }

    public void setConnectionType(ConnectionType type) {
        this.myType_ = type;
    }

    public ConnectionType getConnectionType() {
        return this.myType_;
    }

    public void setLazyAssociatableConnectionManager(LazyAssociatableConnectionManager cm) {
        this.lazyAssocCm_ = cm;
    }

    public void setLazyEnlistableConnectionManager(LazyEnlistableConnectionManager cm) {
        this.lazyEnlistCm_ = cm;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkValidity();
        this.con.setTypeMap(map);
    }

    public static enum ConnectionType {
        LAZY_ENLISTABLE,
        LAZY_ASSOCIATABLE,
        STANDARD;

    }
}

