/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.SecKey;
import java.io.IOException;

public class ServerHandShake
extends HandShake {
    private SecKey serverSecKey;
    private String enabledExtensions;
    private String enabledProtocols;

    public ServerHandShake(Request request, boolean secure, ByteChunk chunk) {
        super(secure, request.requestURI().toString());
        MimeHeaders headers = request.getMimeHeaders();
        this.determineHostAndPort(headers);
        this.checkForHeader(headers, "Upgrade", "WebSocket");
        this.checkForHeader(headers, "Connection", "Upgrade");
        this.setSubProtocol(this.split(headers.getHeader("Sec-WebSocket-Protocol")));
        this.setExtensions(this.split(headers.getHeader("Sec-WebSocket-Extensions")));
        this.serverSecKey = SecKey.generateServerKey(new SecKey(headers.getHeader("Sec-WebSocket-Key")));
        this.setOrigin(this.readHeader(headers, "Sec-WebSocket-Origin"));
        this.setLocation(this.buildLocation(secure));
        if (this.getServerHostName() == null || this.getOrigin() == null) {
            throw new HandshakeException("Missing required headers for WebSocket negotiation");
        }
    }

    private String[] split(String header) {
        return header == null ? null : header.split(";");
    }

    private void checkForHeader(MimeHeaders headers, String header, String validValue) {
        String value = headers.getHeader(header);
        if (!validValue.equalsIgnoreCase(value)) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    final String readHeader(MimeHeaders headers, String name) {
        MessageBytes value = headers.getValue(name);
        return value == null ? null : value.toString();
    }

    public void respond(Response response) {
        response.setStatus(101);
        response.setMessage("Switching Protocols");
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader("Connection", "Upgrade");
        response.setHeader("Sec-WebSocket-Accept", this.serverSecKey.getSecKey());
        if (this.getEnabledProtocols() != null) {
            response.setHeader("Sec-WebSocket-Protocol", this.join(this.getSubProtocol()));
        }
        if (this.getEnabledExtensions() != null) {
            response.setHeader("Sec-WebSocket-Extensions", this.join(this.getSubProtocol()));
        }
        try {
            response.sendHeaders();
            response.flush();
        }
        catch (IOException e) {
            throw new HandshakeException(e.getMessage(), e);
        }
    }

    private void determineHostAndPort(MimeHeaders headers) {
        int i;
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.setServerHostName(header);
            this.setPort("80");
        } else {
            this.setServerHostName(header.substring(0, i));
            this.setPort(header.substring(i + 1));
        }
    }

    public String getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public void setEnabledExtensions(String[] enabledExtensions) {
        this.enabledExtensions = enabledExtensions != null ? this.join(enabledExtensions) : null;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols != null ? this.join(enabledProtocols) : null;
    }
}

