/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import com.sun.enterprise.config.serverbeans.Engine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.web.plugin.common.EnvEntry;
import org.glassfish.web.plugin.common.WebEnvEntryCommand;
import org.glassfish.web.plugin.common.WebModuleConfig;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-web-env-entry")
@I18n(value="setWebEnvEntry.command")
@Scoped(value=PerLookup.class)
public class SetWebEnvEntryCommand
extends WebEnvEntryCommand {
    @Param(name="name")
    private String name;
    @Param(name="value", optional=true)
    private String value;
    @Param(name="type", optional=true)
    private String envEntryType;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="ignoreDescriptorItem", optional=true)
    private Boolean ignoreDescriptorItem;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Engine engine = this.engine(report);
            if (engine != null) {
                this.setEnvEntry(engine, this.name, this.description, this.ignoreDescriptorItem, this.value, this.envEntryType, report);
            }
        }
        catch (Exception e) {
            this.fail(report, e, "errSetEnvEntry", "Error setting env entry", new Object[0]);
        }
    }

    private void setEnvEntry(Engine owningEngine, String name, String description, Boolean ignoreDescriptorItem, String value, String envEntryType, ActionReport report) throws PropertyVetoException, TransactionFailure {
        WebModuleConfig config = WebModuleConfig.Duck.webModuleConfig(owningEngine);
        if (config == null) {
            this.createEnvEntryOnNewWMC(owningEngine, name, value, envEntryType, description, ignoreDescriptorItem);
        } else {
            EnvEntry entry = config.getEnvEntry(name);
            if (entry == null) {
                if (this.isTypeOrIgnorePresent(ignoreDescriptorItem, envEntryType, report)) {
                    this.createEnvEntryOnExistingWMC(config, name, value, envEntryType, description, ignoreDescriptorItem);
                }
            } else {
                this.modifyEnvEntry(entry, value, envEntryType, description, ignoreDescriptorItem);
                this.succeed(report, "setWebEnvEntryOverride", "Previous env-entry setting of {0} for application/module {1} was overridden.", name, this.appNameAndOptionalModuleName());
            }
        }
    }

    private boolean isTypeOrIgnorePresent(Boolean ignoreDescriptorItem, String envEntryType, ActionReport report) {
        boolean result;
        boolean bl = result = ignoreDescriptorItem != null || envEntryType != null;
        if (!result) {
            this.fail(report, "valueOrIgnoreReqd", "The set-web-env-entry command for a new setting requires either the --value option or the --ignoreDescriptorItem option.", new Object[0]);
        }
        return result;
    }

    private void createEnvEntryOnNewWMC(Engine owningEngine, final String name, final String value, final String envEntryType, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Engine>(){

            public Object run(Engine e) throws PropertyVetoException, TransactionFailure {
                WebModuleConfig config = (WebModuleConfig)e.createChild(WebModuleConfig.class);
                e.getApplicationConfigs().add(config);
                EnvEntry envEntry = (EnvEntry)config.createChild(EnvEntry.class);
                config.getEnvEntry().add(envEntry);
                SetWebEnvEntryCommand.this.set(envEntry, name, value, envEntryType, description, ignoreDescriptorItem);
                return config;
            }
        }, (ConfigBeanProxy)owningEngine);
    }

    private void createEnvEntryOnExistingWMC(WebModuleConfig config, final String name, final String value, final String envEntryType, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<WebModuleConfig>(){

            public Object run(WebModuleConfig cf) throws PropertyVetoException, TransactionFailure {
                EnvEntry envEntry = (EnvEntry)cf.createChild(EnvEntry.class);
                cf.getEnvEntry().add(envEntry);
                SetWebEnvEntryCommand.this.set(envEntry, name, value, envEntryType, description, ignoreDescriptorItem);
                return envEntry;
            }
        }, (ConfigBeanProxy)config);
    }

    private void modifyEnvEntry(EnvEntry envEntry, final String value, final String envEntryType, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<EnvEntry>(){

            public Object run(EnvEntry ee) throws PropertyVetoException, TransactionFailure {
                SetWebEnvEntryCommand.this.set(ee, ee.getEnvEntryName(), value, envEntryType, description, ignoreDescriptorItem);
                return ee;
            }
        }, (ConfigBeanProxy)envEntry);
    }

    private void set(EnvEntry envEntry, String name, String value, String envEntryType, String description, Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        String candidateFinalType;
        String candidateFinalValue = value == null ? envEntry.getEnvEntryValue() : value;
        String string = candidateFinalType = envEntryType == null ? envEntry.getEnvEntryType() : envEntryType;
        if (value != null || envEntryType != null) {
            if (candidateFinalValue == null || candidateFinalType == null) {
                String fmt = localStrings.getLocalString("valueAndTypeRequired", "Both a valid --type and --value are required; one is missing");
                throw new IllegalArgumentException(fmt);
            }
            try {
                EnvEntry.Util.validateValue(candidateFinalType, candidateFinalValue);
            }
            catch (IllegalArgumentException ex) {
                String fmt = localStrings.getLocalString("valueTypeMismatch", "Cannot assign value {0} to an env-entry of type {1}", new Object[]{candidateFinalValue, candidateFinalType});
                String valueOrType = value != null ? "--value" : "--type";
                throw new PropertyVetoException(fmt + " - " + ex.getLocalizedMessage(), new PropertyChangeEvent(envEntry, valueOrType, envEntry.getEnvEntryType(), envEntryType));
            }
        }
        envEntry.setEnvEntryName(name);
        if (envEntryType != null) {
            envEntry.setEnvEntryType(envEntryType);
        }
        if (value != null) {
            envEntry.setEnvEntryValue(value);
        }
        if (envEntryType != null) {
            envEntry.setEnvEntryType(envEntryType);
        }
        if (description != null) {
            envEntry.setDescription(description);
        }
        if (ignoreDescriptorItem != null) {
            envEntry.setIgnoreDescriptorItem(ignoreDescriptorItem.toString());
        }
    }
}

