/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.CommandThreadPool;
import com.sun.enterprise.admin.util.InstanceStateFileProcessor;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class InstanceStateService
implements Startup {
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private Domain domain;
    @Inject
    private Logger logger;
    @Inject
    private CommandThreadPool cmdPool;
    private InstanceStateFileProcessor stateProcessor;
    private HashMap<String, InstanceState> instanceStates;
    private final int MAX_RECORDED_FAILED_COMMANDS = 10;

    private void init() {
        if (this.instanceStates != null) {
            return;
        }
        this.instanceStates = new HashMap();
        File stateFile = new File(this.serverEnv.getConfigDirPath().getAbsolutePath(), ".instancestate");
        try {
            this.stateProcessor = new InstanceStateFileProcessor(this.instanceStates, stateFile);
        }
        catch (IOException ioe) {
            this.logger.log(Level.INFO, "unable to read instance state file {0}, recreating", stateFile);
            this.instanceStates = new HashMap();
            try {
                this.stateProcessor = InstanceStateFileProcessor.createNew(this.instanceStates, stateFile);
            }
            catch (IOException ex) {
                this.logger.log(Level.SEVERE, "unable to create instance state file " + stateFile, ex);
                this.stateProcessor = null;
            }
        }
    }

    public synchronized void addServerToStateService(String instanceName) {
        this.init();
        this.instanceStates.put(instanceName, new InstanceState(InstanceState.StateType.NEVER_STARTED));
        try {
            this.stateProcessor.addNewServer(instanceName);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while adding new server state to instance state: {0}", e.getLocalizedMessage());
        }
    }

    public synchronized void addFailedCommandToInstance(String instance, String cmd, ParameterMap params) {
        this.init();
        String cmdDetails = cmd;
        String defArg = (String)params.getOne((Object)"DEFAULT");
        if (defArg != null) {
            cmdDetails = cmdDetails + " " + defArg;
        }
        try {
            InstanceState i = this.instanceStates.get(instance);
            if (i != null && i.getState() != InstanceState.StateType.NEVER_STARTED && i.getFailedCommands().size() < 10) {
                i.addFailedCommands(cmdDetails);
                this.stateProcessor.addFailedCommand(instance, cmdDetails);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while adding failed command to instance state: {0}", e.getLocalizedMessage());
        }
    }

    public synchronized void removeFailedCommandsForInstance(String instance) {
        this.init();
        try {
            InstanceState i = this.instanceStates.get(instance);
            if (i != null) {
                i.removeFailedCommands();
                this.stateProcessor.removeFailedCommands(instance);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while removing failed commands from instance state: {0}", e.getLocalizedMessage());
        }
    }

    public InstanceState.StateType getState(String instanceName) {
        this.init();
        InstanceState s = this.instanceStates.get(instanceName);
        if (s == null) {
            return InstanceState.StateType.NEVER_STARTED;
        }
        return s.getState();
    }

    public List<String> getFailedCommands(String instanceName) {
        this.init();
        InstanceState s = this.instanceStates.get(instanceName);
        if (s == null) {
            return new ArrayList<String>();
        }
        return s.getFailedCommands();
    }

    public synchronized InstanceState.StateType setState(String name, InstanceState.StateType newState, boolean force) {
        InstanceState.StateType currState;
        this.init();
        boolean updateXML = false;
        InstanceState.StateType ret = newState;
        InstanceState is = this.instanceStates.get(name);
        if (is == null || (currState = is.getState()) == null) {
            this.instanceStates.put(name, new InstanceState(newState));
            updateXML = true;
            ret = newState;
        } else if (!force && currState == InstanceState.StateType.RESTART_REQUIRED) {
            updateXML = false;
            ret = currState;
        } else if (!(force || currState != InstanceState.StateType.NEVER_STARTED || newState != InstanceState.StateType.NOT_RUNNING && newState != InstanceState.StateType.RESTART_REQUIRED && newState != InstanceState.StateType.NO_RESPONSE)) {
            updateXML = false;
            ret = currState;
        } else if (!currState.equals((Object)newState)) {
            this.instanceStates.get(name).setState(newState);
            updateXML = true;
            ret = newState;
        }
        try {
            if (updateXML) {
                this.stateProcessor.updateState(name, newState.getDescription());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while setting instance state: {0}", e.getLocalizedMessage());
        }
        return ret;
    }

    public synchronized void removeInstanceFromStateService(String name) {
        this.init();
        this.instanceStates.remove(name);
        try {
            this.stateProcessor.removeInstanceNode(name);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while removing instance: {0}", e.getLocalizedMessage());
        }
    }

    public Future<InstanceCommandResult> submitJob(Server server, InstanceCommand ice, InstanceCommandResult r) {
        return this.cmdPool.submitJob(ice, r);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

