/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import com.sun.enterprise.glassfish.bootstrap.StartupContextUtil;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;

public abstract class ASMainOSGi
extends PlatformMain {
    private Properties ctx;
    protected File glassfishDir;
    protected File domainDir;
    protected ClassLoader launcherCL;
    protected File fwDir;
    private String[] additionalJars = new String[0];

    public void start(Properties ctx) throws Exception {
        this.ctx = ctx;
        this.glassfishDir = StartupContextUtil.getInstallRoot(ctx);
        this.domainDir = StartupContextUtil.getInstanceRoot(ctx);
        this.setFwDir();
        this.setupLauncherClassLoader();
        this.configureEnvironment();
        this.launchOSGiFW();
    }

    protected abstract void setFwDir();

    protected abstract void addFrameworkJars(ClassPathBuilder var1) throws IOException;

    protected abstract void launchOSGiFW() throws Exception;

    protected void configureEnvironment() throws Exception {
        try {
            StringWriter writer = new StringWriter();
            this.ctx.store(writer, null);
            System.setProperty("com.sun.enterprise.glassfish.bootstrap.args", ((Object)writer).toString());
        }
        catch (IOException e) {
            this.logger.info("Could not save startup parameters, will start with none");
            System.setProperty("com.sun.enterprise.glassfish.bootstrap.args", "");
        }
        System.setProperty("com.sun.aas.installRootURI", this.glassfishDir.toURI().toString());
        System.setProperty("com.sun.aas.instanceRootURI", this.domainDir.toURI().toString());
        File cacheProfileDir = this.getCacheDir();
        System.setProperty("org.osgi.framework.storage", cacheProfileDir.getAbsolutePath());
        System.setProperty("com.sun.enterprise.hk2.cacheDir", cacheProfileDir.getAbsolutePath());
        this.configureProvisioningBundle();
    }

    protected final File getCacheDir() {
        return new File(this.domainDir, this.getPreferedCacheDir());
    }

    protected abstract String getPreferedCacheDir();

    protected void configureProvisioningBundle() {
        System.setProperty("org.jvnet.hk2.osgimain.bundlesDir", new File(this.glassfishDir, "modules/").getAbsolutePath());
        System.setProperty("org.jvnet.hk2.osgimain.excludedSubDirs", "autostart/");
        if (System.getProperty("org.jvnet.hk2.osgimain.autostartBundles") == null) {
            String bundlePaths = "glassfish.jar";
            System.setProperty("org.jvnet.hk2.osgimain.autostartBundles", "glassfish.jar");
        }
    }

    private void setupLauncherClassLoader() throws Exception {
        ClassLoader extCL = ClassLoader.getSystemClassLoader().getParent();
        ClassPathBuilder cpb = new ClassPathBuilder(extCL);
        try {
            this.addFrameworkJars(cpb);
            this.addJDKToolsJar(cpb);
            this.findDerbyClient(cpb);
            File moduleDir = new File(this.glassfishDir, "modules/");
            cpb.addGlob(moduleDir, this.additionalJars);
            this.launcherCL = cpb.create();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Thread.currentThread().setContextClassLoader(this.launcherCL);
    }

    private void addJDKToolsJar(ClassPathBuilder cpb) {
        try {
            File jdkToolsJar = Util.getJDKToolsJar();
            if (jdkToolsJar.exists()) {
                cpb.addJar(jdkToolsJar);
            } else {
                this.logger.fine("JDK tools.jar does not exist at " + jdkToolsJar);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void findDerbyClient(ClassPathBuilder cpb) throws IOException {
        String derbyHome = ASMainHelper.parseAsEnv(this.glassfishDir).getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        cpb.addGlob(derbyLib, "derby*.jar");
    }
}

