/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarUtil {
    public static final String JAXR_RA_NAME = "jaxr-ra";
    public static final String JDBCDATASOURCE_RA_NAME = "__ds_jdbc_ra";
    public static final String JDBCCONNECTIONPOOLDATASOURCE_RA_NAME = "__cp_jdbc_ra";
    public static final String JDBCXA_RA_NAME = "__xa_jdbc_ra";
    public static final String JDBCDRIVER_RA_NAME = "__dm_jdbc_ra";
    public static final String DEFAULT_JMS_ADAPTER = "jmsra";
    public static final String RAR_EXTENSION = ".rar";
    public static final List<String> systemRarNames = Collections.unmodifiableList(Arrays.asList("jaxr-ra", "__ds_jdbc_ra", "__cp_jdbc_ra", "__xa_jdbc_ra", "__dm_jdbc_ra", "jmsra"));
    private static final Logger _logger = Logger.getAnonymousLogger();

    private static String getSystemModuleLocation(String installDir, String rarName) {
        return installDir + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + rarName;
    }

    private static boolean systemModuleLocationExists(String installDir, String rarName) {
        return new File(JarUtil.getSystemModuleLocation(installDir, rarName)).exists();
    }

    public static boolean extractRars(String installDir) {
        boolean extracted = true;
        for (String rarName : systemRarNames) {
            extracted &= JarUtil.extractRar(installDir, rarName);
        }
        return extracted;
    }

    public static void setEnv(String installDir) {
        String imqLib = System.getProperty("com.sun.aas.imqLib", JarUtil.getSystemModuleLocation(installDir, DEFAULT_JMS_ADAPTER));
        System.setProperty("com.sun.aas.imqLib", imqLib);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean extractRar(String installDir, String rarName) {
        if (JarUtil.systemModuleLocationExists(installDir, rarName)) {
            return false;
        }
        InputStream is = JarUtil.class.getClassLoader().getResourceAsStream(rarName + RAR_EXTENSION);
        if (is != null) {
            File file;
            String fileName;
            block22: {
                IOException ioe2;
                FileOutputStream os;
                block21: {
                    fileName = installDir + File.separator + rarName + RAR_EXTENSION;
                    os = null;
                    os = new FileOutputStream(fileName);
                    Util.copy(is, os, is.available());
                    Object var9_5 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!_logger.isLoggable(Level.FINEST)) break block21;
                        _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe2);
                    }
                }
                try {
                    is.close();
                }
                catch (IOException ioe2) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe2);
                    }
                    break block22;
                }
                {
                    catch (IOException e) {
                        boolean bl;
                        block24: {
                            block23: {
                                Object[] args = new Object[]{rarName, e};
                                _logger.log(Level.WARNING, "error.extracting.archive", args);
                                bl = false;
                                Object var9_6 = null;
                                try {
                                    if (os != null) {
                                        os.close();
                                    }
                                }
                                catch (IOException ioe2) {
                                    if (!_logger.isLoggable(Level.FINEST)) break block23;
                                    _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe2);
                                }
                            }
                            try {
                                is.close();
                            }
                            catch (IOException ioe2) {
                                if (!_logger.isLoggable(Level.FINEST)) break block24;
                                _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe2);
                            }
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    block26: {
                        block25: {
                            Object var9_7 = null;
                            try {
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (IOException ioe2) {
                                if (!_logger.isLoggable(Level.FINEST)) break block25;
                                _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe2);
                            }
                        }
                        try {
                            is.close();
                        }
                        catch (IOException ioe2) {
                            if (!_logger.isLoggable(Level.FINEST)) break block26;
                            _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe2);
                        }
                    }
                    throw throwable;
                }
            }
            if ((file = new File(fileName)).exists()) {
                try {
                    JarUtil.extractJar(file, installDir);
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            _logger.log(Level.INFO, "could not find RAR [ " + rarName + " ] location [ " + fileName + " ] " + "after extraction");
            return false;
        }
        _logger.log(Level.FINEST, "could not find RAR [ " + rarName + " ] in the archive, skipping .rar extraction");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractJar(File jarFile, String destDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enum1 = jar.entries();
        while (enum1.hasMoreElements()) {
            Exception e2;
            InputStream is;
            JarEntry file;
            block14: {
                Object var11_10;
                file = enum1.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                if (f.exists()) continue;
                is = null;
                FileOutputStream fos = null;
                try {
                    is = jar.getInputStream(file);
                    fos = new FileOutputStream(f);
                    int count = 0;
                    byte[] buffer = new byte[8192];
                    while ((count = is.read(buffer, 0, buffer.length)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    block16: {
                        block15: {
                            var11_10 = null;
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (Exception e2) {
                                if (!_logger.isLoggable(Level.FINEST)) break block15;
                                _logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e2);
                            }
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception e2) {
                            if (!_logger.isLoggable(Level.FINEST)) break block16;
                            _logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    if (!_logger.isLoggable(Level.FINEST)) break block14;
                    _logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e2);
                }
            }
            try {
                if (is == null) continue;
                is.close();
            }
            catch (Exception e2) {
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e2);
            }
        }
    }
}

