/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import java.io.IOException;
import java.util.Vector;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.internal.api.LogManager;
import org.jvnet.hk2.component.Habitat;

public class LogNamesResource {
    @Context
    protected Habitat habitat;

    @GET
    @Produces(value={"text/plain", "application/json"})
    public String getLogNamesJSON(@QueryParam(value="instanceName") String instanceName) throws IOException {
        return this.getLogNames(instanceName, "json");
    }

    @GET
    @Produces(value={"application/xml"})
    public String getLogNamesJXML(@QueryParam(value="instanceName") String instanceName) throws IOException {
        return this.getLogNames(instanceName, "xml");
    }

    private String getLogNames(String instanceName, String type) throws IOException {
        if (this.habitat.getComponent(LogManager.class) == null) {
            throw new IOException("The GlassFish LogManager Service is not available. Not installed?");
        }
        LogFilter logFilter = (LogFilter)this.habitat.getComponent(LogFilter.class);
        return this.convertQueryResult(logFilter.getInstanceLogFileNames(instanceName), type);
    }

    private String quoted(String s) {
        return "\"" + s + "\"";
    }

    private String convertQueryResult(Vector v, String type) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (type.equals("json")) {
            sb.append("{\"InstanceLogFileNames\": [");
        } else {
            sb.append("<InstanceLogFileNames>\n");
        }
        for (int i = 0; i < v.size(); ++i) {
            String name = (String)v.get(i);
            if (type.equals("json")) {
                sb.append(sep);
                sb.append(this.quoted(name));
                sep = ",";
                continue;
            }
            sb.append("<" + name + "/>");
        }
        if (type.equals("json")) {
            sb.append("]}\n");
        } else {
            sb.append("\n</InstanceLogFileNames>\n");
        }
        return sb.toString();
    }
}

