/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebFragmentDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="war")
@Scoped(value=PerLookup.class)
public class WarScanner
extends ModuleScanner<WebBundleDescriptor> {
    protected boolean scanOtherLibraries = false;
    @Inject
    protected ClassLoaderHierarchy clh;

    public void setScanOtherLibraries(boolean scanOtherLibraries) {
        this.scanOtherLibraries = scanOtherLibraries;
    }

    public boolean isScanOtherLibraries() {
        return this.scanOtherLibraries;
    }

    public void process(File archiveFile, WebBundleDescriptor webBundleDesc, ClassLoader classLoader) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void process(ReadableArchive readableArchive, WebBundleDescriptor webBundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
        this.archiveFile = new File(readableArchive.getURI());
        this.classLoader = classLoader;
        if (parser == null) {
            ParsingContext.Builder builder = new ParsingContext.Builder();
            builder.logger(this.logger);
            ParsingContext pc = builder.build();
            parser = new Parser(pc);
        }
        this.classParser = parser;
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + this.archiveFile);
            AnnotationUtils.getLogger().fine("webBundle is " + webBundleDesc);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        if (!this.archiveFile.isDirectory()) {
            return;
        }
        if (this.isScanOtherLibraries()) {
            this.addLibraryJars(webBundleDesc, readableArchive);
            this.calculateResults();
            return;
        }
        File webinf = new File(this.archiveFile, "WEB-INF");
        if (webBundleDesc instanceof WebFragmentDescriptor) {
            File jarFile;
            WebFragmentDescriptor webFragmentDesc = (WebFragmentDescriptor)webBundleDesc;
            File lib = new File(webinf, "lib");
            if (lib.exists() && (jarFile = new File(lib, webFragmentDesc.getJarName())).exists()) {
                if (jarFile.isDirectory()) {
                    this.addScanDirectory(jarFile);
                } else {
                    this.addScanJar(jarFile);
                }
            }
        } else {
            File classes = new File(webinf, "classes");
            if (classes.exists()) {
                this.addScanDirectory(classes);
            }
            this.scanXmlDefinedClassesIfNecessary(webBundleDesc);
        }
        this.calculateResults();
    }

    private void scanXmlDefinedClassesIfNecessary(WebBundleDescriptor webBundleDesc) throws IOException {
        ClassLoader commonCL = this.clh.getCommonClassLoader();
        for (WebComponentDescriptor webCompDesc : webBundleDesc.getWebComponentDescriptors()) {
            String servletName;
            if (!webCompDesc.isServlet() || !this.isScan(servletName = webCompDesc.getWebComponentImplementation(), commonCL)) continue;
            this.addScanClassName(servletName);
        }
        Vector<ServletFilter> servletFilters = webBundleDesc.getServletFilters();
        for (int i = 0; i < servletFilters.size(); ++i) {
            ServletFilter filter = servletFilters.elementAt(i);
            String filterName = filter.getClassName();
            if (!this.isScan(filterName, commonCL)) continue;
            this.addScanClassName(filter.getClassName());
        }
        Vector<AppListenerDescriptor> listeners = webBundleDesc.getAppListenerDescriptors();
        for (int j = 0; j < listeners.size(); ++j) {
            AppListenerDescriptor listenerDesc = listeners.elementAt(j);
            String listenerName = listenerDesc.getListener();
            if (!this.isScan(listenerName, commonCL)) continue;
            this.addScanClassName(listenerDesc.getListener());
        }
    }

    private boolean isScan(String className, ClassLoader commonCL) throws IOException {
        boolean result = false;
        String resourceName = "/" + className.replace(".", "/") + ".class";
        return commonCL.getResource(resourceName) != null;
    }
}

