/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFileFactory;
import com.sun.enterprise.deployment.io.runtime.RuntimeDDFileFactory;
import com.sun.enterprise.deployment.node.ApplicationNode;
import com.sun.enterprise.deployment.node.JaxrpcMappingDescriptorNode;
import com.sun.enterprise.deployment.node.PersistenceNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.WebServicesDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.appclient.AppClientNode;
import com.sun.enterprise.deployment.node.ejb.EjbBundleNode;
import com.sun.enterprise.deployment.node.runtime.AppClientRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.EjbBundleRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.GFAppClientRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.GFEjbBundleRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.application.ApplicationRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.application.GFApplicationRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.connector.ConnectorNode;
import com.sun.enterprise.deployment.node.runtime.web.GFWebBundleRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.web.WLWebBundleRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import com.sun.enterprise.deployment.node.web.WebBundleNode;
import com.sun.enterprise.deployment.node.web.WebFragmentNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.xml.DTDRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxParserHandler
extends DefaultHandler {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static volatile boolean _MappingStuffInited = false;
    private static final MappingStuff _mappingStuff = new MappingStuff();
    private final List<XMLNode> nodes = new ArrayList<XMLNode>();
    public XMLNode topNode = null;
    protected String publicID = null;
    private StringBuffer elementData = null;
    private Map prefixMapping = null;
    private boolean stopOnXMLErrors = false;
    private boolean pushedNamespaceContext = false;
    private final NamespaceSupport namespaces;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SaxParserHandler.class);
    private String errorReportingString = "";

    protected static Hashtable<String, String> getMapping() {
        return SaxParserHandler._mappingStuff.mMapping;
    }

    public SaxParserHandler() {
        SaxParserHandler.Init();
        this.namespaces = new NamespaceSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void Init() {
        if (_MappingStuffInited) {
            return;
        }
        Class<SaxParserHandler> clazz = SaxParserHandler.class;
        synchronized (SaxParserHandler.class) {
            Map rootNodes = _mappingStuff.mRootNodesMutable;
            Hashtable<String, String> mapping = SaxParserHandler._mappingStuff.mMapping;
            String rootNode = ApplicationNode.registerBundle(mapping);
            rootNodes.put(rootNode, ApplicationNode.class);
            rootNode = EjbBundleNode.registerBundle(mapping);
            rootNodes.put(rootNode, EjbBundleNode.class);
            rootNode = com.sun.enterprise.deployment.node.connector.ConnectorNode.registerBundle(mapping);
            rootNodes.put(rootNode, com.sun.enterprise.deployment.node.connector.ConnectorNode.class);
            rootNode = WebBundleNode.registerBundle(mapping);
            rootNodes.put(rootNode, WebBundleNode.class);
            rootNode = WebFragmentNode.registerBundle(mapping);
            rootNodes.put(rootNode, WebFragmentNode.class);
            rootNode = AppClientNode.registerBundle(mapping);
            rootNodes.put(rootNode, AppClientNode.class);
            rootNode = WebServicesDescriptorNode.ROOT_ELEMENT.getQName();
            rootNodes.put(rootNode, WebServicesDescriptorNode.class);
            rootNode = JaxrpcMappingDescriptorNode.ROOT_ELEMENT.getQName();
            rootNodes.put(rootNode, JaxrpcMappingDescriptorNode.class);
            rootNode = PersistenceNode.ROOT_ELEMENT.getQName();
            rootNodes.put(rootNode, PersistenceNode.class);
            rootNodes.put("sun-application", ApplicationRuntimeNode.class);
            ApplicationRuntimeNode.registerBundle(mapping);
            rootNodes.put("sun-web-app", WebBundleRuntimeNode.class);
            WebBundleRuntimeNode.registerBundle(mapping);
            rootNodes.put("sun-ejb-jar", EjbBundleRuntimeNode.class);
            EjbBundleRuntimeNode.registerBundle(mapping);
            rootNodes.put("sun-application-client", AppClientRuntimeNode.class);
            AppClientRuntimeNode.registerBundle(mapping);
            rootNodes.put("sun-connector", ConnectorNode.class);
            ConnectorNode.registerBundle(mapping);
            rootNodes.put("glassfish-application-client", GFAppClientRuntimeNode.class);
            GFAppClientRuntimeNode.registerBundle(mapping);
            rootNodes.put("glassfish-application", GFApplicationRuntimeNode.class);
            GFApplicationRuntimeNode.registerBundle(mapping);
            rootNodes.put("glassfish-ejb-jar", GFEjbBundleRuntimeNode.class);
            GFEjbBundleRuntimeNode.registerBundle(mapping);
            rootNodes.put("glassfish-web-app", GFWebBundleRuntimeNode.class);
            GFWebBundleRuntimeNode.registerBundle(mapping);
            rootNodes.put("weblogic-web-app", WLWebBundleRuntimeNode.class);
            Enumeration<String> publicIDs = mapping.keys();
            while (publicIDs.hasMoreElements()) {
                String publicID = publicIDs.nextElement();
                String dtd = mapping.get(publicID);
                mapping.put(publicID, dtd.substring(dtd.lastIndexOf(47) + 1));
            }
            _MappingStuffInited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void registerMapping(String publicID, String systemID) {
        SaxParserHandler.getMapping().put(publicID, systemID);
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        try {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Asked to resolve  " + publicID + " system id = " + systemID);
            }
            if (publicID == null) {
                if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                    return null;
                }
                String fileName = SaxParserHandler.getSchemaURLFor(systemID.substring(systemID.lastIndexOf(47) + 1));
                if (fileName == null) {
                    fileName = systemID;
                }
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                    DOLUtils.getDefaultLogger().fine("Resolved to " + fileName);
                }
                return new InputSource(fileName);
            }
            if (SaxParserHandler.getMapping().containsKey(publicID)) {
                this.publicID = publicID;
                return new InputSource(new BufferedInputStream(this.getDTDUrlFor(SaxParserHandler.getMapping().get(publicID))));
            }
        }
        catch (Exception ioe) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, ioe.getMessage(), ioe);
            throw new SAXException(ioe);
        }
        return null;
    }

    public void setStopOnError(boolean stop) {
        this.stopOnXMLErrors = stop;
    }

    @Override
    public void error(SAXParseException spe) throws SAXParseException {
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorFailure", new Object[]{this.errorReportingString, String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()});
        if (this.stopOnXMLErrors) {
            throw spe;
        }
    }

    @Override
    public void warning(SAXParseException spe) throws SAXParseException {
        String x = spe.getMessage();
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXParseException {
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorFailure", new Object[]{this.errorReportingString, String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()});
        if (this.stopOnXMLErrors) {
            throw spe;
        }
    }

    protected InputStream getDTDUrlFor(String dtdFileName) {
        String dtdLoc = DTDRegistry.DTD_LOCATION.replace('/', File.separatorChar);
        File f = new File(dtdLoc + File.separatorChar + dtdFileName);
        try {
            return new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException fnfe) {
            DOLUtils.getDefaultLogger().fine("Cannot find DTD " + dtdFileName);
            return null;
        }
    }

    public static String getSchemaURLFor(String schemaSystemID) throws IOException {
        File f = SaxParserHandler.getSchemaFileFor(schemaSystemID);
        if (f != null) {
            return f.toURI().toURL().toString();
        }
        return null;
    }

    public static File getSchemaFileFor(String schemaSystemID) throws IOException {
        String schemaLoc;
        File f;
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Getting Schema " + schemaSystemID);
        }
        if (!(f = new File((schemaLoc = DTDRegistry.SCHEMA_LOCATION.replace('/', File.separatorChar)) + File.separatorChar + schemaSystemID)).exists()) {
            DOLUtils.getDefaultLogger().fine("Cannot find schema " + schemaSystemID);
            return null;
        }
        return f;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Received notation " + name + " :=: " + publicId + " :=: " + systemId);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixMapping == null) {
            this.prefixMapping = new HashMap();
        }
        if (!this.pushedNamespaceContext) {
            this.namespaces.pushContext();
            this.pushedNamespaceContext = true;
        }
        this.namespaces.declarePrefix(prefix, uri);
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!this.pushedNamespaceContext) {
            this.namespaces.pushContext();
        }
        this.pushedNamespaceContext = false;
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
            DOLUtils.getDefaultLogger().finer("start of element " + uri + " with local name " + localName + " and " + qName);
        }
        XMLNode node = null;
        this.elementData = new StringBuffer();
        if (this.nodes.isEmpty()) {
            Class rootNodeClass = SaxParserHandler._mappingStuff.mRootNodes.get(localName);
            if (rootNodeClass == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{localName, " not supported !"});
                if (this.stopOnXMLErrors) {
                    throw new IllegalArgumentException(localStrings.getLocalString("invalid.root.element", "{0} Element [{1}] is not a valid root element", new Object[]{this.errorReportingString, localName}));
                }
            } else {
                try {
                    node = (XMLNode)rootNodeClass.newInstance();
                    if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                        DOLUtils.getDefaultLogger().fine("Instanciating " + node);
                    }
                    if (node instanceof RootXMLNode) {
                        if (this.publicID != null) {
                            ((RootXMLNode)node).setDocType(this.publicID);
                        }
                        this.addPrefixMapping(node);
                    }
                    this.nodes.add(node);
                    this.topNode = node;
                    node.getDescriptor();
                }
                catch (Exception e) {
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
                    return;
                }
            }
        } else {
            node = this.nodes.get(this.nodes.size() - 1);
        }
        if (node != null) {
            XMLElement element = new XMLElement(qName, this.namespaces);
            if (node.handlesElement(element)) {
                node.startElement(element, attributes);
            } else {
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                    DOLUtils.getDefaultLogger().fine("Asking for new handler for " + element + " to " + node);
                }
                XMLNode newNode = node.getHandlerFor(element);
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                    DOLUtils.getDefaultLogger().fine("Got " + newNode);
                }
                this.nodes.add(newNode);
                this.addPrefixMapping(newNode);
                newNode.startElement(element, attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
            DOLUtils.getDefaultLogger().finer("End of element " + uri + " local name " + localName + " and " + qName + " value " + this.elementData);
        }
        if (this.nodes.size() == 0) {
            this.elementData = null;
            return;
        }
        XMLElement element = new XMLElement(qName, this.namespaces);
        XMLNode topNode = this.nodes.get(this.nodes.size() - 1);
        if (this.elementData != null && (this.elementData.length() != 0 || this.allowsEmptyValue(element.getQName()))) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
                DOLUtils.getDefaultLogger().finer("For element " + element.getQName() + " And value " + this.elementData);
            }
            if (element.getQName().equals("url-pattern")) {
                topNode.setElementValue(element, this.elementData.toString());
            } else if (element.getQName().equals("env-entry-value")) {
                Object envEntryDesc = topNode.getDescriptor();
                if (envEntryDesc != null && envEntryDesc instanceof EnvironmentProperty) {
                    EnvironmentProperty envProp = (EnvironmentProperty)envEntryDesc;
                    if (envProp.getType() != null && (envProp.getType().equals("java.lang.String") || envProp.getType().equals("java.lang.Character"))) {
                        topNode.setElementValue(element, this.elementData.toString());
                    } else {
                        topNode.setElementValue(element, this.elementData.toString().trim());
                    }
                } else {
                    topNode.setElementValue(element, this.elementData.toString().trim());
                }
            } else {
                topNode.setElementValue(element, this.elementData.toString().trim());
            }
            this.elementData = null;
        }
        if (topNode.endElement(element)) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Removing top node " + topNode);
            }
            this.nodes.remove(this.nodes.size() - 1);
        }
        this.namespaces.popContext();
        this.pushedNamespaceContext = false;
    }

    @Override
    public void characters(char[] ch, int start, int stop) {
        if (this.elementData != null) {
            this.elementData = this.elementData.append(ch, start, stop);
        }
    }

    public XMLNode getTopNode() {
        return this.topNode;
    }

    public void setTopNode(XMLNode node) {
        this.topNode = node;
        this.nodes.add(node);
    }

    private void addPrefixMapping(XMLNode node) {
        if (this.prefixMapping != null) {
            for (String prefix : this.prefixMapping.keySet()) {
                node.addPrefixMapping(prefix, (String)this.prefixMapping.get(prefix));
            }
            this.prefixMapping = null;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String fileName = args[0];
        File inFile = new File(fileName);
        if (!inFile.exists()) {
            return;
        }
        try {
            BufferedInputStream is;
            DeploymentDescriptorFile ddFile = DeploymentDescriptorFileFactory.getDDFileFor(inFile);
            long timeStart = System.currentTimeMillis();
            RootDeploymentDescriptor desc = null;
            ddFile.setXMLValidation(true);
            for (int i = 0; i < 10; ++i) {
                is = new BufferedInputStream(new FileInputStream(inFile));
                desc = (RootDeploymentDescriptor)ddFile.read(is);
                ((InputStream)is).close();
            }
            if (desc != null && args.length > 1 && args[1] != "-o") {
                is = new BufferedInputStream(new FileInputStream(new File(args[1])));
                ddFile = RuntimeDDFileFactory.getDDFileFor(desc);
                ddFile.read(desc, is);
            }
            long timeEnd = System.currentTimeMillis();
            if (args.length > 2 && args[2].equals("-o")) {
                ddFile.write(desc, new File(args[3]));
            }
        }
        catch (Throwable t) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", t);
        }
    }

    public void setErrorReportingString(String s) {
        this.errorReportingString = s;
    }

    private boolean allowsEmptyValue(String elementName) {
        return elementName.equals("library-directory") || elementName.equals("load-on-startup");
    }

    private static final class MappingStuff {
        public final Hashtable<String, String> mMapping = new Hashtable();
        private final Map<String, Class> mRootNodesMutable = new HashMap<String, Class>();
        public final Map<String, Class> mRootNodes = Collections.unmodifiableMap(this.mRootNodesMutable);

        MappingStuff() {
        }
    }
}

