/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.transformer;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderClassFileTransformer
implements ClassFileTransformer {
    private static Instrumentation _inst;
    private static boolean _debug;
    private Class providerClass;
    private Map<String, FlashlightProbe> probes = new HashMap<String, FlashlightProbe>();
    private ClassWriter cw;
    private static final Logger _logger;

    public ProbeProviderClassFileTransformer(Class providerClass) {
        this.providerClass = providerClass;
    }

    public void registerProbe(FlashlightProbe probe) {
        java.lang.reflect.Method m = probe.getProbeMethod();
        if (m == null) {
            try {
                m = probe.getProviderClazz().getDeclaredMethod(probe.getProviderJavaMethodName(), probe.getParamTypes());
                probe.setProbeMethod(m);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Error during registration of FlashlightProbe", ex);
            }
        }
        this.probes.put(probe.getProviderJavaMethodName() + "::" + Type.getMethodDescriptor((java.lang.reflect.Method)m), probe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform() {
        try {
            ProbeProviderClassFileTransformer.getInstrumentation();
            if (_inst != null) {
                _inst.addTransformer(this, true);
                _inst.retransformClasses(this.providerClass);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error during re-transformation", e);
        }
        finally {
            if (_inst != null) {
                _inst.removeTransformer(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (classBeingRedefined != this.providerClass) return classfileBuffer;
            this.cw = new ClassWriter(3);
            ClassReader cr = new ClassReader(classfileBuffer);
            cr.accept((ClassVisitor)new ProbeProviderClassVisitor((ClassVisitor)this.cw), null, 0);
            classfileBuffer = this.cw.toByteArray();
            if (!_debug) return classfileBuffer;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Error during registration of FlashlightProbe", ex);
        }
        return classfileBuffer;
    }

    private static final String makeKey(String name, String desc) {
        return name + "::" + desc;
    }

    private static final void getInstrumentation() {
        if (_inst == null) {
            try {
                ProbeProviderClassFileTransformer.class.getClassLoader();
                ClassLoader scl = ClassLoader.getSystemClassLoader();
                Class<?> agentMainClass = scl.loadClass("org.glassfish.flashlight.agent.ProbeAgentMain");
                java.lang.reflect.Method mthd = agentMainClass.getMethod("getInstrumentation", null);
                _inst = (Instrumentation)mthd.invoke(null, null);
                _logger.log(Level.INFO, "Successfully got INSTRUMENTATION: " + _inst);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error while getting Instrumentation object from ProbeAgentmain", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeFile(String name, byte[] data) {
        FileOutputStream fos = null;
        try {
            File dir = new File("/space/work/v3/trunk/glassfish3/glassfish/flashlight-generated");
            dir.mkdirs();
            fos = new FileOutputStream(new File(dir, name + ".class"));
            fos.write(data);
        }
        catch (Throwable th) {
            _logger.log(Level.INFO, "Couldn't write the retransformed class data", th);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception ex) {}
        }
    }

    static {
        _logger = Logger.getLogger(ProbeProviderClassFileTransformer.class.getName());
    }

    private class ProbeProviderMethodVisitor
    extends MethodAdapter {
        private FlashlightProbe probe;
        private int access;
        private String name;
        private String desc;

        ProbeProviderMethodVisitor(MethodVisitor mv, int access, String name, String desc, FlashlightProbe probe) {
            super(mv);
            this.probe = probe;
            this.access = access;
            this.name = name;
            this.desc = desc;
        }

        public void visitCode() {
            super.visitCode();
            GeneratorAdapter gen = new GeneratorAdapter(this.mv, this.access, this.name, this.desc);
            gen.push(this.probe.getId());
            gen.loadArgArray();
            gen.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod((String)"void invokeProbe(int, Object[])"));
        }
    }

    private class ProbeProviderClassVisitor
    extends ClassAdapter {
        ProbeProviderClassVisitor(ClassVisitor cv) {
            super(cv);
            for (String methodDesc : ProbeProviderClassFileTransformer.this.probes.keySet()) {
                _logger.log(Level.FINE, "ProbeProviderClassVisitor will visit" + methodDesc);
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Object mv = super.visitMethod(access, name, desc, signature, exceptions);
            FlashlightProbe probe = (FlashlightProbe)ProbeProviderClassFileTransformer.this.probes.get(ProbeProviderClassFileTransformer.makeKey(name, desc));
            if (probe != null) {
                mv = new ProbeProviderMethodVisitor((MethodVisitor)mv, access, name, desc, probe);
            }
            return mv;
        }
    }
}

