/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLIProcessExecutor;
import com.sun.enterprise.admin.cli.optional.DatabaseCommand;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="start-database")
@Scoped(value=PerLookup.class)
public final class StartDatabaseCommand
extends DatabaseCommand {
    private static final String DATABASE_DIR_NAME = "databases";
    @Param(name="dbhome", optional=true)
    private String dbHome;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDatabaseCommand.class);

    public String[] startDatabaseCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "start", this.dbHost, this.dbPort, "true", this.dbHome};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "start", this.dbHost, this.dbPort, "true", this.dbHome};
    }

    public String[] sysinfoCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
    }

    private String getDatabaseHomeDir() {
        if (this.dbHome != null) {
            return this.dbHome;
        }
        String currentDir = System.getProperty("user.dir");
        if (new File(currentDir, "derby.log").exists()) {
            return currentDir;
        }
        File installPath = GFLauncherUtils.getInstallDir();
        if (installPath != null) {
            File dbDir = new File(installPath, DATABASE_DIR_NAME);
            dbDir.mkdir();
            try {
                return dbDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                return dbDir.getAbsolutePath();
            }
        }
        return null;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        CLIProcessExecutor cpe = new CLIProcessExecutor();
        String dbLog = "";
        int exitCode = 0;
        try {
            this.prepareProcessExecutor();
            this.dbHome = this.getDatabaseHomeDir();
            if (this.dbHome != null) {
                dbLog = this.dbHome + File.separator + "derby.log";
            }
            logger.finer("Ping Database");
            cpe.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
            if (cpe.exitValue() > 0) {
                logger.finer("Start Database");
                cpe.execute("startDatabaseCmd", this.startDatabaseCmd(), false);
                if (cpe.exitValue() != 0) {
                    throw new CommandException(strings.get("UnableToStartDatabase", new Object[]{dbLog}));
                }
            } else {
                if (cpe.exitValue() < 0) {
                    throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}));
                }
                logger.info(strings.get("StartDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
            }
        }
        catch (IllegalThreadStateException ite) {
            CLIProcessExecutor cpePing = new CLIProcessExecutor();
            CLIProcessExecutor cpeSysInfo = new CLIProcessExecutor();
            try {
                if (!this.programOpts.isTerse()) {
                    logger.fine(strings.get("database.info.msg", new Object[]{this.dbHost, this.dbPort}));
                }
                cpePing.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
                for (int counter = 0; cpePing.exitValue() != 0 && counter < 10; ++counter) {
                    cpePing.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
                    Thread.sleep(500L);
                    try {
                        cpe.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException itse) {
                        continue;
                    }
                }
                if (!this.programOpts.isTerse()) {
                    logger.finer("Database SysInfo");
                    if (cpePing.exitValue() == 0) {
                        cpeSysInfo.execute("sysinfoCmd", this.sysinfoCmd(), true);
                        if (cpeSysInfo.exitValue() != 0) {
                            logger.info(strings.get("CouldNotGetSysInfo"));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
            }
            if (cpePing.exitValue() == 0) {
                logger.info(strings.get("DatabaseStartMsg"));
                if (new File(dbLog).canWrite()) {
                    logger.info(strings.get("LogRedirectedTo", new Object[]{dbLog}));
                }
            }
            throw new CommandException(strings.get("UnableToStartDatabase", new Object[]{dbLog}));
        }
        catch (Exception e) {
            throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
        return exitCode;
    }
}

