/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ThreadPoolStatistic;
import com.sun.grizzly.util.AbstractThreadPool;
import com.sun.grizzly.util.GrizzlyExecutorService;
import com.sun.grizzly.util.ThreadPoolConfig;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsThreadPool
extends GrizzlyExecutorService {
    public static int DEFAULT_MIN_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    public static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected int port;
    private final Object startStopSync = new Object();
    private volatile boolean wasEverStarted;
    protected transient ThreadPoolStatistic threadPoolStat;

    public StatsThreadPool() {
        this(AbstractThreadPool.DEFAULT_MAX_TASKS_QUEUED);
    }

    public StatsThreadPool(int maxTasksCount) {
        this(AbstractThreadPool.DEFAULT_MIN_THREAD_COUNT, AbstractThreadPool.DEFAULT_MAX_THREAD_COUNT, maxTasksCount, AbstractThreadPool.DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public StatsThreadPool(int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        this("Grizzly", corePoolSize, maximumPoolSize, maxTasksCount, keepAliveTime, unit);
    }

    public StatsThreadPool(String name, int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        this(new ThreadPoolConfig(name, corePoolSize, maximumPoolSize, null, maxTasksCount, keepAliveTime, unit, null, 5, null));
    }

    public StatsThreadPool(ThreadPoolConfig config) {
        super(config, false);
        this.config.setThreadFactory((ThreadFactory)new HttpWorkerThreadFactory(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startStopSync;
        synchronized (object) {
            this.setImpl(this.config);
            this.wasEverStarted = true;
        }
    }

    public void stop() {
        this.shutdown();
    }

    public final void execute(Runnable r) {
        if (!this.wasEverStarted) {
            this.start();
        }
        super.execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (!this.wasEverStarted) {
                return;
            }
            super.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> shutdownNow() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (!this.wasEverStarted) {
                return Collections.emptyList();
            }
            return super.shutdownNow();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setStatistic(ThreadPoolStatistic threadPoolStatistic) {
        this.threadPoolStat = threadPoolStatistic;
    }

    public ThreadPoolStatistic getStatistic() {
        return this.threadPoolStat;
    }

    public GrizzlyExecutorService reconfigure(ThreadPoolConfig config) {
        if (this.wasEverStarted) {
            return super.reconfigure(config);
        }
        this.config = config;
        return this;
    }

    public int getLargestPoolSize() {
        if (!this.wasEverStarted) {
            return 0;
        }
        return super.getLargestPoolSize();
    }

    public int getPoolSize() {
        if (!this.wasEverStarted) {
            return 0;
        }
        return super.getPoolSize();
    }

    public int getQueueSize() {
        if (!this.wasEverStarted) {
            return 0;
        }
        return super.getQueueSize();
    }

    public int getActiveCount() {
        if (!this.wasEverStarted) {
            return 0;
        }
        return super.getActiveCount();
    }

    public int getTaskCount() {
        if (!this.wasEverStarted) {
            return 0;
        }
        return super.getTaskCount();
    }

    public long getCompletedTaskCount() {
        if (!this.wasEverStarted) {
            return 0L;
        }
        return super.getCompletedTaskCount();
    }

    public boolean isShutdown() {
        if (!this.wasEverStarted) {
            return false;
        }
        return super.isShutdown();
    }

    public boolean isTerminated() {
        if (!this.wasEverStarted) {
            return false;
        }
        return super.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.wasEverStarted) {
            return true;
        }
        return super.awaitTermination(timeout, unit);
    }

    public String toString() {
        return super.toString() + ", port=" + this.port;
    }

    protected void injectToStringAttributes(StringBuilder sb) {
        sb.append(this.toString());
    }

    protected static class HttpWorkerThreadFactory
    implements ThreadFactory {
        private final StatsThreadPool statsThreadPool;

        public HttpWorkerThreadFactory(StatsThreadPool statsThreadPool) {
            this.statsThreadPool = statsThreadPool;
        }

        public Thread newThread(final Runnable r) {
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    HttpWorkerThread thread = new HttpWorkerThread(null, r);
                    ((Thread)((Object)thread)).setContextClassLoader(HttpWorkerThreadFactory.class.getClassLoader());
                    return thread;
                }
            });
        }
    }
}

