/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.DigestEncoder;

public class DigestAuthenticator
extends AuthenticatorBase {
    protected static final int USE_ONCE = 1;
    protected static final int USE_NEVER_EXPIRES = Integer.MAX_VALUE;
    protected static final int TIMEOUT_INFINITE = Integer.MAX_VALUE;
    protected static final DigestEncoder digestEncoder = new DigestEncoder();
    protected static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    private static final String EMPTY_STRING = "";
    protected static volatile String algorithm = "MD5";
    protected static volatile MessageDigest messageDigest;
    protected Hashtable<String, Long> nOnceTokens = new Hashtable();
    protected long nOnceTimeout = Integer.MAX_VALUE;
    protected int nOnceUses = 1;
    protected String key = "Catalina";

    public static String getAlgorithm() {
        return algorithm;
    }

    public static synchronized void setAlgorithm(String alg) {
        algorithm = alg;
        messageDigest = null;
    }

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        if (authorization != null && (principal = this.context.getRealm().authenticate(hreq)) != null) {
            String username = this.parseUsername(authorization);
            this.register(request, response, principal, "DIGEST", username, null);
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.getSession(request, true);
            }
            return true;
        }
        String nOnce = this.generateNOnce(hreq);
        this.setAuthenticateHeader(hreq, hres, config, nOnce);
        hres.sendError(401);
        return false;
    }

    protected static Principal findPrincipal(HttpServletRequest request, String authorization, Realm realm) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        Object opaque = null;
        String method = request.getMethod();
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = currentTokenValue;
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        byte[] buffer = DigestAuthenticator.digest(a2.getBytes());
        char[] md5a2 = digestEncoder.encode(buffer);
        char[] responseCharArray = response.toCharArray();
        return realm.authenticate(userName, responseCharArray, nOnce, nc, cnonce, qop, realmName, md5a2);
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return EMPTY_STRING;
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    protected String generateNOnce(HttpServletRequest request) {
        long currentTime = System.currentTimeMillis();
        String nOnceValue = request.getRemoteAddr() + ":" + currentTime + ":" + this.key;
        byte[] buffer = DigestAuthenticator.digest(nOnceValue.getBytes());
        nOnceValue = String.valueOf(digestEncoder.encode(buffer));
        this.nOnceTokens.put(nOnceValue, currentTime + this.nOnceTimeout);
        return nOnceValue;
    }

    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, LoginConfig config, String nOnce) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = "Authentication required";
        }
        byte[] buffer = DigestAuthenticator.digest(nOnce.getBytes());
        String authenticateHeader = "Digest realm=\"" + realmName + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + String.valueOf(digestEncoder.encode(buffer)) + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }

    protected static synchronized MessageDigest getMessageDigest() {
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(algorithm + " digest algorithm not available", e);
            }
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] digest(byte[] data) {
        MessageDigest md;
        byte[] buffer = null;
        MessageDigest messageDigest = md = DigestAuthenticator.getMessageDigest();
        synchronized (messageDigest) {
            buffer = md.digest(data);
        }
        return buffer;
    }
}

