/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.CompletionHandler;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.ResponseFilter;
import com.sun.grizzly.tcp.http11.Constants;
import com.sun.grizzly.tcp.http11.GrizzlyOutputBuffer;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlySession;
import com.sun.grizzly.tcp.http11.GrizzlyWriter;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UEncoder;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.http.ServerCookie;
import com.sun.grizzly.util.res.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyResponse<A> {
    private boolean cacheEnabled = false;
    private String detailErrorMsg;
    private static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected SimpleDateFormat format = null;
    protected static final String info = "com.sun.grizzly.util.tcp.GrizzlyResponse/1.0";
    protected static StringManager sm = StringManager.getManager("com.sun.grizzly.tcp.http11", Constants.class.getClassLoader());
    protected GrizzlyRequest request = null;
    protected Response response;
    protected final GrizzlyOutputBuffer outputBuffer;
    protected GrizzlyOutputStream outputStream;
    protected GrizzlyWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    private boolean isContentTypeSet = false;
    protected boolean error = false;
    protected ArrayList cookies = new ArrayList(4);
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected MessageBytes redirectURLCC = new MessageBytes();

    public GrizzlyResponse() {
        this(false, false);
    }

    public GrizzlyResponse(boolean chunkingDisabled, boolean cacheEnabled) {
        this.outputBuffer = new GrizzlyOutputBuffer(chunkingDisabled);
        this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        this.writer = new GrizzlyWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
        this.cacheEnabled = cacheEnabled;
    }

    public GrizzlyRequest getRequest() {
        return this.request;
    }

    public void setRequest(GrizzlyRequest request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
        this.outputBuffer.setResponse(response);
    }

    public Response getResponse() {
        return this.response;
    }

    public void recycle() {
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.isContentTypeSet = false;
        this.isCharacterEncodingSet = false;
        this.detailErrorMsg = null;
        this.cookies.clear();
        if (System.getSecurityManager() != null) {
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else {
            this.writer.recycle();
        }
        this.cacheEnabled = false;
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url, false);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.request.getSession().getIdInternal());
        }
        return url;
    }

    protected boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        GrizzlySession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        if (this.request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        return this.doIsEncodeable(this.request, session, location);
    }

    private boolean doIsEncodeable(GrizzlyRequest request, GrizzlySession session, String location) {
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = request.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(request.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = "/";
        if (contextPath != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getIdInternal()) >= 0) {
                return false;
            }
        }
        return true;
    }

    public int getContentCount() {
        return this.outputBuffer.getContentWritten();
    }

    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isBufferSuspended() || this.getContentLength() > 0 && this.getContentCount() >= this.getContentLength();
    }

    public boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getInfo() {
        return info;
    }

    public OutputStream getStream() {
        if (this.outputStream == null) {
            this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void setStream(OutputStream stream) {
    }

    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    public boolean isBufferSuspended() {
        return this.outputBuffer.isSuspended();
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public void setDetailMessage(String message) {
        this.detailErrorMsg = message;
    }

    public String getDetailMessage() {
        return this.detailErrorMsg;
    }

    public GrizzlyOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void finishResponse() throws IOException {
        try {
            this.outputBuffer.close();
        }
        catch (IOException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getContentLength() {
        this.checkResponse();
        return this.response.getContentLength();
    }

    public String getContentType() {
        this.checkResponse();
        return this.response.getContentType();
    }

    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = new GrizzlyWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        this.checkResponse();
        return this.response.getCharacterEncoding();
    }

    public GrizzlyOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("response.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public Locale getLocale() {
        this.checkResponse();
        return this.response.getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("response.getWriter.ise"));
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = new GrizzlyWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        this.checkResponse();
        return this.response.isCommitted();
    }

    public void reset() {
        this.checkResponse();
        if (this.included) {
            return;
        }
        this.response.reset();
        this.outputBuffer.reset();
    }

    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.resetBuffer.ise"));
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("response.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLengthLong(long length) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLengthLong(length);
    }

    public void setContentLength(int length) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLength(length);
    }

    public void setContentType(String type) {
        int index;
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.response.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 7 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                this.isCharacterEncodingSet = true;
            }
        }
        this.isContentTypeSet = true;
    }

    public void setCharacterEncoding(String charset) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setCharacterEncoding(charset);
        this.isCharacterEncodingSet = true;
    }

    public void setLocale(Locale locale) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getHeader(String name) {
        this.checkResponse();
        return this.response.getMimeHeaders().getHeader(name);
    }

    public String[] getHeaderNames() {
        this.checkResponse();
        MimeHeaders headers = this.response.getMimeHeaders();
        int n = headers.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = headers.getName(i).toString();
        }
        return result;
    }

    public String[] getHeaderValues(String name) {
        this.checkResponse();
        Enumeration<String> e = this.response.getMimeHeaders().values(name);
        LinkedList<String> result = new LinkedList<String>();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getMessage() {
        this.checkResponse();
        return this.response.getMessage();
    }

    public int getStatus() {
        this.checkResponse();
        return this.response.getStatus();
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(final Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        final StringBuffer sb = new StringBuffer();
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
                    return null;
                }
            });
        } else {
            ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        }
        this.addHeader("Set-Cookie", sb.toString());
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    public void addHeader(String name, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        this.checkResponse();
        return this.response.containsHeader(name);
    }

    public void sendAcknowledgement() throws IOException {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.acknowledge();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkResponse();
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.response.setStatus(status);
        this.response.setMessage(message);
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location, true);
            this.setStatus(302);
            this.setHeader("Location", absolute);
            this.setContentType("text/html");
            this.setLocale(Locale.getDefault());
            String filteredMsg = GrizzlyResponse.filter(absolute);
            StringBuilder sb = new StringBuilder(150 + absolute.length());
            sb.append("<html>\r\n");
            sb.append("<head><title>Document moved</title></head>\r\n");
            sb.append("<body><h1>Document moved</h1>\r\n");
            sb.append("This document has moved <a href=\"");
            sb.append(filteredMsg);
            sb.append("\">here</a>.<p>\r\n");
            sb.append("</body>\r\n");
            sb.append("</html>\r\n");
            try {
                this.getWriter().write(sb.toString());
                this.getWriter().flush();
            }
            catch (IllegalStateException ise1) {
                try {
                    this.getOutputStream().print(sb.toString());
                }
                catch (IllegalStateException ise2) {}
            }
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    public void setHeader(String name, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String message) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.setStatus(status);
        this.response.setMessage(message);
    }

    protected String toAbsolute(String location, boolean normalize) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !leadingSlash && location.indexOf("://") == -1) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            CharChunk cc = this.redirectURLCC.getCharChunk();
            try {
                cc.append(scheme, 0, scheme.length());
                cc.append("://", 0, 3);
                cc.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    cc.append(':');
                    String portS = port + "";
                    cc.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = pos != -1 ? relativePath.substring(0, pos) : "";
                    String encodedURI = null;
                    final String frelativePath = relativePath;
                    if (System.getSecurityManager() != null) {
                        try {
                            encodedURI = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return GrizzlyResponse.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            IllegalArgumentException iae = new IllegalArgumentException(location);
                            iae.initCause(pae.getCause());
                            throw iae;
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    cc.append(encodedURI, 0, encodedURI.length());
                    cc.append('/');
                }
                cc.append(location, 0, location.length());
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
            if (normalize) {
                HttpRequestURIDecoder.normalize(this.redirectURLCC);
            }
            return cc.toString();
        }
        return location;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    protected String toEncoded(String url, String sessionId) {
        String jrouteId;
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        if ((jrouteId = this.request.getHeader("proxy-jroute")) != null) {
            sb.append(":");
            sb.append(jrouteId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void enableCache(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        this.outputBuffer.enableCache(cacheEnabled);
    }

    public GrizzlyOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setChunkingDisabled(boolean chunkingDisabled) {
        if (this.outputBuffer != null) {
            this.outputBuffer.setChunkingDisabled(chunkingDisabled);
        }
    }

    public boolean getChunkingDisabled() {
        if (this.outputBuffer != null) {
            this.outputBuffer.getChunkingDisabled();
        }
        return true;
    }

    public void resume() {
        this.checkResponse();
        this.response.resume();
    }

    public void cancel() {
        this.checkResponse();
        this.response.cancel();
    }

    public boolean isSuspended() {
        this.checkResponse();
        return this.response.isSuspended();
    }

    public void suspend() {
        this.suspend(Long.MAX_VALUE);
    }

    public void suspend(long timeout) {
        this.suspend(timeout, null, null);
    }

    public void suspend(long timeout, A attachment, CompletionHandler<? super A> competionHandler) {
        this.checkResponse();
        this.response.suspend(timeout, attachment, competionHandler, new GrizzlyResponseAttachment<A>(timeout, attachment, competionHandler, this));
    }

    void checkResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Internal com.sun.grizzly.tcp.Response has not been set");
        }
    }

    public void addResponseFilter(ResponseFilter responseFilter) {
        this.response.addResponseFilter(responseFilter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrizzlyResponseAttachment<A>
    extends Response.ResponseAttachment {
        private final GrizzlyResponse grizzlyResponse;

        public GrizzlyResponseAttachment(long timeout, A attachment, CompletionHandler<? super A> completionHandler, GrizzlyResponse grizzlyResponse) {
            super(timeout, attachment, completionHandler, grizzlyResponse.getResponse());
            this.grizzlyResponse = grizzlyResponse;
        }

        @Override
        public void resume() {
            this.getCompletionHandler().resumed(this.getAttachment());
            try {
                this.grizzlyResponse.finishResponse();
            }
            catch (IOException ex) {
                LoggerUtils.getLogger().log(Level.FINEST, "resume", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean timeout() {
            try {
                this.cancel();
            }
            finally {
                if (!this.grizzlyResponse.isCommitted()) {
                    try {
                        this.grizzlyResponse.finishResponse();
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }
    }
}

