/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.FieldPartitioningPolicy;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuePartitioningPolicy
extends FieldPartitioningPolicy {
    protected Map<Object, String> partitions = new HashMap<Object, String>();
    protected String defaultConnectionPool;

    public ValuePartitioningPolicy() {
    }

    public ValuePartitioningPolicy(String partitionField) {
        super(partitionField);
    }

    public ValuePartitioningPolicy(String partitionField, boolean unionUnpartitionableQueries) {
        super(partitionField, unionUnpartitionableQueries);
    }

    public String getDefaultConnectionPool() {
        return this.defaultConnectionPool;
    }

    public void setDefaultConnectionPool(String defaultConnectionPool) {
        this.defaultConnectionPool = defaultConnectionPool;
    }

    public Map<Object, String> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Map<Object, String> partitions) {
        this.partitions = partitions;
    }

    public void addPartition(Object value, String connectionPool) {
        this.getPartitions().put(value, connectionPool);
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        Object value = arguments.get(this.partitionField);
        if (value == null) {
            if (this.unionUnpartitionableQueries) {
                ArrayList<Accessor> accessors = new ArrayList<Accessor>(this.partitions.size());
                for (String poolName : this.partitions.values()) {
                    accessors.add(this.getAccessor(poolName, session, query, false));
                }
                return accessors;
            }
            return null;
        }
        ArrayList<Accessor> accessors = new ArrayList<Accessor>(1);
        String poolName = this.partitions.get(value);
        if (poolName == null) {
            if (this.defaultConnectionPool == null) {
                return null;
            }
            poolName = this.defaultConnectionPool;
        }
        if (session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().setPartitionId(Integer.parseInt(poolName));
            return null;
        }
        accessors.add(this.getAccessor(poolName, session, query, false));
        return accessors;
    }

    @Override
    public void partitionPersist(AbstractSession session, Object object, ClassDescriptor descriptor) {
        Object value = this.extractPartitionValueForPersist(session, object, descriptor);
        if (value == null) {
            return;
        }
        String poolName = this.partitions.get(value);
        if (poolName == null) {
            return;
        }
        if (session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().setPartitionId(Integer.parseInt(poolName));
        } else {
            this.getAccessor(poolName, session, null, false);
        }
    }
}

