/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;

public class IndirectMap
extends Hashtable
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Hashtable delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 11;
    protected float loadFactor = 0.75f;

    public IndirectMap() {
        this(11);
    }

    public IndirectMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IndirectMap(int initialCapacity, float loadFactor) {
        super(0);
        this.initialize(initialCapacity, loadFactor);
    }

    public IndirectMap(Map m) {
        super(0);
        this.initialize(m);
    }

    protected Hashtable buildDelegate() {
        Hashtable value = (Hashtable)this.getValueHolder().getValue();
        if (value == null) {
            value = new Hashtable(this.initialCapacity, this.loadFactor);
        }
        return value;
    }

    public synchronized void clear() {
        if (this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.keySet().iterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(o, this.get(o));
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectMap result = (IndirectMap)super.clone();
        result.delegate = (Hashtable)this.getDelegate().clone();
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    public synchronized boolean contains(Object value) {
        return this.getDelegate().contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    public synchronized Enumeration elements() {
        return this.getDelegate().elements();
    }

    public Set entrySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            public int size() {
                return this.delegateSet.size();
            }

            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(((Map.Entry)this.currentObject).getKey(), ((Map.Entry)this.currentObject).getValue());
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.delegateSet.toArray(a);
            }

            public boolean add(Object o) {
                return this.delegateSet.add(o);
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)o).getKey()) != null;
            }

            public boolean containsAll(Collection c) {
                return this.delegateSet.containsAll(c);
            }

            public boolean addAll(Collection c) {
                return this.delegateSet.addAll(c);
            }

            public boolean retainAll(Collection c) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Map.Entry object = (Map.Entry)objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object.getKey(), object.getValue());
                    result = true;
                }
                return result;
            }

            public boolean removeAll(Collection c) {
                boolean result = false;
                for (Object object : c) {
                    Object removed;
                    if (!(object instanceof Map.Entry) || (removed = IndirectMap.this.remove(((Map.Entry)object).getKey())) == null) continue;
                    result = true;
                }
                return result;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object o) {
                return ((Object)this.delegateSet).equals(o);
            }

            public int hashCode() {
                return ((Object)this.delegateSet).hashCode();
            }
        };
    }

    public synchronized boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public synchronized Object get(Object key) {
        return this.getDelegate().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getDelegate() {
        if (this.delegate == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    public Object getDelegateObject() {
        return this.getDelegate();
    }

    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Hashtable(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return this.valueHolder;
    }

    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    protected void initialize(int initialCapacity, float loadFactor) {
        this.delegate = null;
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity;
        this.valueHolder = null;
    }

    protected void initialize(Map m) {
        this.delegate = null;
        Hashtable temp = new Hashtable(m);
        this.valueHolder = new ValueHolder(temp);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public synchronized Enumeration keys() {
        return this.getDelegate().keys();
    }

    public Set keySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            public int size() {
                return this.delegateSet.size();
            }

            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject, IndirectMap.this.getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.delegateSet.toArray(a);
            }

            public boolean add(Object o) {
                return this.delegateSet.add(o);
            }

            public boolean remove(Object o) {
                return IndirectMap.this.remove(o) != null;
            }

            public boolean containsAll(Collection c) {
                return this.delegateSet.containsAll(c);
            }

            public boolean addAll(Collection c) {
                return this.delegateSet.addAll(c);
            }

            public boolean retainAll(Collection c) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Object object = objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object, IndirectMap.this.getDelegate().get(object));
                    result = true;
                }
                return result;
            }

            public boolean removeAll(Collection c) {
                boolean result = false;
                Iterator cs = c.iterator();
                while (cs.hasNext()) {
                    if (IndirectMap.this.remove(cs.next()) == null) continue;
                    result = true;
                }
                return result;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object o) {
                return ((Object)this.delegateSet).equals(o);
            }

            public int hashCode() {
                return ((Object)this.delegateSet).hashCode();
            }
        };
    }

    public synchronized Object put(Object key, Object value) {
        Object oldValue = this.getDelegate().put(key, value);
        if (oldValue != null) {
            this.raiseRemoveChangeEvent(key, oldValue);
        }
        this.raiseAddChangeEvent(key, value);
        return oldValue;
    }

    public synchronized void putAll(Map t) {
        if (this.hasTrackedPropertyChangeListener()) {
            for (Object key : t.keySet()) {
                this.put(key, t.get(key));
            }
        } else {
            this.getDelegate().putAll(t);
        }
    }

    protected void rehash() {
        throw new InternalError("unsupported");
    }

    protected void raiseAddChangeEvent(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value, CollectionChangeEvent.ADD, true));
        }
    }

    protected void raiseRemoveChangeEvent(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value, CollectionChangeEvent.REMOVE, true));
        }
    }

    public synchronized Object remove(Object key) {
        Object value = this.getDelegate().remove(key);
        if (value != null) {
            this.raiseRemoveChangeEvent(key, value);
        }
        return value;
    }

    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public Collection getRemovedElements() {
        return null;
    }

    public Collection getAddedElements() {
        return null;
    }

    public boolean hasDeferredChanges() {
        return false;
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public Collection values() {
        return new Collection(){
            protected Collection delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            public int size() {
                return this.delegateCollection.size();
            }

            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            public boolean contains(Object o) {
                return this.delegateCollection.contains(o);
            }

            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        for (Map.Entry entry : IndirectMap.this.getDelegate().entrySet()) {
                            if (!entry.getValue().equals(this.currentObject)) continue;
                            IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                        }
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.delegateCollection.toArray(a);
            }

            public boolean add(Object o) {
                return this.delegateCollection.add(o);
            }

            public boolean remove(Object o) {
                Iterator iterator = IndirectMap.this.getDelegate().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue().equals(o)) {
                        IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    }
                    return true;
                }
                return false;
            }

            public boolean containsAll(Collection c) {
                return this.delegateCollection.containsAll(c);
            }

            public boolean addAll(Collection c) {
                return this.delegateCollection.addAll(c);
            }

            public boolean removeAll(Collection c) {
                boolean result = false;
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    if (!this.remove(iterator.next())) continue;
                    result = true;
                }
                return result;
            }

            public boolean retainAll(Collection c) {
                boolean result = false;
                Iterator iterator = IndirectMap.this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (c.contains(entry.getValue())) continue;
                    iterator.remove();
                    result = true;
                }
                return result;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object o) {
                return ((Object)this.delegateCollection).equals(o);
            }

            public int hashCode() {
                return ((Object)this.delegateCollection).hashCode();
            }
        };
    }
}

