/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;

public class XMLDirectMappingNodeValue
extends MappingNodeValue
implements NullCapableValue {
    private XMLDirectMapping xmlDirectMapping;

    public XMLDirectMappingNodeValue(XMLDirectMapping xmlDirectMapping) {
        this.xmlDirectMapping = xmlDirectMapping;
    }

    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        this.xmlDirectMapping.getNullPolicy().xPathNode(xPathNode, this);
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.isAttribute() || xPathFragment.nameIsText();
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlDirectMapping.isReadOnly()) {
            return false;
        }
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlDirectMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext);
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment fragment;
        Object fieldValue = this.xmlDirectMapping.getFieldValue(objectValue, session, marshalRecord);
        if (null == fieldValue) {
            return this.xmlDirectMapping.getNullPolicy().directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        QName schemaType = this.getSchemaType((XMLField)this.xmlDirectMapping.getField(), fieldValue, session);
        XPathFragment groupingFragment = null;
        boolean isQName = false;
        if (XMLConstants.QNAME_QNAME.equals(schemaType)) {
            groupingFragment = this.openGroupingElementsForQName((QName)fieldValue, marshalRecord);
            isQName = true;
        }
        if (groupingFragment == null) {
            groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        }
        String stringValue = this.getValueToWrite(schemaType, fieldValue, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), marshalRecord);
        if (xPathFragment.isAttribute()) {
            marshalRecord.attribute(xPathFragment, namespaceResolver, stringValue);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            marshalRecord.closeStartGroupingElements(groupingFragment);
            if (this.xmlDirectMapping.isCDATA()) {
                marshalRecord.cdata(stringValue);
            } else {
                marshalRecord.characters(stringValue);
            }
        }
        if (isQName && (fragment = this.getLastGroupingFragment()) != groupingFragment) {
            marshalRecord.endElement(groupingFragment, namespaceResolver);
            return false;
        }
        return true;
    }

    private XPathFragment getLastGroupingFragment() {
        XPathFragment fragment = ((XMLField)this.getMapping().getField()).getXPathFragment();
        if (fragment.isAttribute() || fragment.nameIsText()) {
            return null;
        }
        while (fragment.getNextFragment() != null) {
            if (fragment.getNextFragment().nameIsText() || fragment.getNextFragment().isAttribute()) {
                return fragment;
            }
            fragment = fragment.getNextFragment();
        }
        return fragment;
    }

    private XPathFragment openGroupingElementsForQName(QName fieldValue, MarshalRecord marshalRecord) {
        XPathFragment xPathFragment = null;
        ArrayList<XPathNode> groupingElements = marshalRecord.getGroupingElements();
        NamespaceResolver namespaceResolver = marshalRecord.getNamespaceResolver();
        if ((fieldValue.getNamespaceURI() == null || fieldValue.getNamespaceURI().equals("")) && marshalRecord.getNamespaceResolver().getDefaultNamespaceURI() != null) {
            int groupingElementsSize = groupingElements.size();
            for (int x = 0; x < groupingElementsSize; ++x) {
                XPathNode xPathNode = groupingElements.get(x);
                xPathFragment = xPathNode.getXPathFragment();
                if (x == groupingElements.size() - 1 && namespaceResolver.getDefaultNamespaceURI().equals(xPathFragment.getNamespaceURI()) && xPathFragment.getPrefix() == null) {
                    String prefix = namespaceResolver.generatePrefix();
                    String xPath = prefix + ":" + xPathFragment.getShortName();
                    XPathFragment newFragment = new XPathFragment(xPath);
                    newFragment.setNamespaceURI(namespaceResolver.getDefaultNamespaceURI());
                    marshalRecord.openStartElement(newFragment, namespaceResolver);
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceResolver.getDefaultNamespaceURI());
                    marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                    xPathFragment = newFragment;
                    continue;
                }
                marshalRecord.openStartElement(xPathFragment, namespaceResolver);
                marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                marshalRecord.closeStartElement();
            }
            marshalRecord.setGroupingElement(null);
        }
        return xPathFragment;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        unmarshalRecord.removeNullCapableValue(this);
        XMLField xmlField = (XMLField)this.xmlDirectMapping.getField();
        Object realValue = xmlField.convertValueBasedOnSchemaType(value, (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager(), unmarshalRecord);
        Object convertedValue = this.xmlDirectMapping.getAttributeValue(realValue, unmarshalRecord.getSession(), unmarshalRecord);
        this.xmlDirectMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), convertedValue);
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.removeNullCapableValue(this);
        XMLField xmlField = (XMLField)this.xmlDirectMapping.getField();
        if (!xmlField.getLastXPathFragment().nameIsText()) {
            return;
        }
        Object value = unmarshalRecord.getStringBuffer().length() == 0 ? this.getMapping().getNullValue() : unmarshalRecord.getStringBuffer().toString();
        unmarshalRecord.resetStringBuffer();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = xmlField.getJavaClass(unmarshalRecord.getTypeQName());
            value = xmlConversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = xmlField.convertValueBasedOnSchemaType(value, xmlConversionManager, unmarshalRecord);
        }
        Object convertedValue = this.xmlDirectMapping.getAttributeValue(value, unmarshalRecord.getSession(), unmarshalRecord);
        unmarshalRecord.setAttributeValue(convertedValue, this.xmlDirectMapping);
    }

    public void setNullValue(Object object, Session session) {
        Object value = this.xmlDirectMapping.getAttributeValue(null, session);
        this.xmlDirectMapping.setAttributeValueInObject(object, value);
    }

    public boolean isNullCapableValue() {
        return this.xmlDirectMapping.getNullPolicy().getIsSetPerformedForAbsentNode();
    }

    public XMLDirectMapping getMapping() {
        return this.xmlDirectMapping;
    }

    public boolean isWhitespaceAware() {
        return !this.xmlDirectMapping.getNullPolicy().isNullRepresentedByEmptyNode();
    }
}

