/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadAllQuery
extends ObjectLevelReadQuery {
    protected ContainerPolicy containerPolicy;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected List<Expression> orderSiblingsByExpressions;

    public ReadAllQuery() {
        this.setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
    }

    public ReadAllQuery(Class classToRead) {
        this();
        this.referenceClass = classToRead;
    }

    public ReadAllQuery(Class classToRead, Expression selectionCriteria) {
        this();
        this.referenceClass = classToRead;
        this.setSelectionCriteria(selectionCriteria);
    }

    public ReadAllQuery(Class classToRead, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.referenceClass = classToRead;
    }

    public ReadAllQuery(Class classToRead, Call call) {
        this();
        this.referenceClass = classToRead;
        this.setCall(call);
    }

    public ReadAllQuery(Object exampleObject, QueryByExamplePolicy policy) {
        this();
        this.setExampleObject(exampleObject);
        this.setQueryByExamplePolicy(policy);
    }

    public ReadAllQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public ReadAllQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void addAscendingOrdering(String queryKeyName) {
        this.addOrdering(this.getExpressionBuilder().get(queryKeyName).ascending());
    }

    @Override
    public void cacheResult(Object unwrappedOriginal) {
        Collection container = (Collection)this.getTemporaryCachedQueryResults();
        if (container == null) {
            container = (Collection)this.getContainerPolicy().containerInstance();
            this.setTemporaryCachedQueryResults(container);
        }
        this.getContainerPolicy().addInto(unwrappedOriginal, container, this.getSession());
    }

    @Override
    protected Object checkEarlyReturnLocal(AbstractSession session, AbstractRecord translationRow) {
        if (this.shouldCheckCacheOnly()) {
            if (this.shouldUseWrapperPolicy()) {
                this.getContainerPolicy().setElementDescriptor(this.descriptor);
            }
            AbstractSession rootSession = session;
            while (rootSession.isUnitOfWork()) {
                rootSession = ((UnitOfWorkImpl)rootSession).getParent();
            }
            Vector allCachedVector = rootSession.getIdentityMapAccessor().getAllFromIdentityMap(this.getSelectionCriteria(), this.getReferenceClass(), (Record)translationRow, this.getInMemoryQueryIndirectionPolicyState(), false);
            if (session.isUnitOfWork()) {
                allCachedVector = ((UnitOfWorkImpl)session).registerAllObjects(allCachedVector);
            }
            return this.getContainerPolicy().buildContainerFromVector(allCachedVector, session);
        }
        return null;
    }

    @Override
    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        if (this.isCustomQueryUsed() == null) {
            this.setIsCustomQueryUsed(!this.isUserDefined() && this.isExpressionQuery() && this.getSelectionCriteria() == null && !this.hasOrderByExpressions() && this.descriptor.getQueryManager().hasReadAllQuery());
        }
        if (this.isCustomQueryUsed().booleanValue()) {
            return this.descriptor.getQueryManager().getReadAllQuery();
        }
        return null;
    }

    @Override
    public Object clone() {
        ReadAllQuery cloneQuery = (ReadAllQuery)super.clone();
        cloneQuery.containerPolicy = this.containerPolicy.clone(cloneQuery);
        return cloneQuery;
    }

    protected Object conformResult(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        int index;
        if (this.getSelectionCriteria() != null) {
            ExpressionBuilder builder = this.getSelectionCriteria().getBuilder();
            builder.setSession(unitOfWork.getRootSession(null));
            builder.setQueryClass(this.getReferenceClass());
        }
        ContainerPolicy cp = this.getRedirector() != null ? ContainerPolicy.buildPolicyFor(result.getClass()) : this.getContainerPolicy();
        Map<Object, Object> indexedInterimResult = unitOfWork.scanForConformingInstances(this.getSelectionCriteria(), this.getReferenceClass(), arguments, this);
        Cursor cursor = null;
        if (cp.isCursorPolicy()) {
            cursor = (Cursor)((Object)result);
            cp = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
            cursor.setSession(unitOfWork);
            result = cursor.getObjectCollection();
            cursor.setInitiallyConformingIndex(indexedInterimResult);
            cursor.setSelectionCriteriaClone(this.getSelectionCriteria());
            cursor.setTranslationRow(arguments);
        }
        ArrayList<Object> fromDatabase = null;
        if (buildDirectlyFromRows) {
            List rows = result;
            int size = rows.size();
            fromDatabase = new ArrayList(size);
            for (index = 0; index < size; ++index) {
                Object clone;
                AbstractRecord row = (AbstractRecord)rows.get(index);
                if (row == null || (clone = this.conformIndividualResult(this.buildObject(row), unitOfWork, arguments, this.getSelectionCriteria(), indexedInterimResult)) == null) continue;
                fromDatabase.add(clone);
            }
        } else {
            fromDatabase = new ArrayList<Object>(cp.sizeFor(result));
            AbstractSession sessionToUse = unitOfWork.getParent();
            Object iter = cp.iteratorFor(result);
            while (cp.hasNext(iter)) {
                Object object = cp.next(iter, sessionToUse);
                Object clone = this.conformIndividualResult(this.registerIndividualResult(object, null, unitOfWork, null, null), unitOfWork, arguments, this.getSelectionCriteria(), indexedInterimResult);
                if (clone == null) continue;
                fromDatabase.add(clone);
            }
        }
        Object conformedResult = cp.containerInstance(indexedInterimResult.size() + fromDatabase.size());
        for (Object eachClone : indexedInterimResult.values()) {
            cp.addInto(eachClone, conformedResult, unitOfWork);
        }
        int size = fromDatabase.size();
        for (index = 0; index < size; ++index) {
            Object eachClone = fromDatabase.get(index);
            cp.addInto(eachClone, conformedResult, unitOfWork);
        }
        if (cursor != null) {
            cursor.setObjectCollection((List)conformedResult);
            if (unitOfWork.isNestedUnitOfWork()) {
                for (Object clone : cursor.getObjectCollection()) {
                    indexedInterimResult.put(clone, clone);
                }
            }
            return cursor;
        }
        return conformedResult;
    }

    @Override
    public Object execute(AbstractSession session, AbstractRecord row) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object queryResults;
            if (this.getContainerPolicy().overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared() && (queryResults = this.getQueryResults(session, row, true)) != null) {
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadAllHits(this);
                }
                session.incrementProfile("Counter:CacheHits", this);
                if (queryResults == InvalidObject.instance) {
                    return this.getContainerPolicy().containerInstance(0);
                }
                Collection results = (Collection)queryResults;
                if (session.isUnitOfWork()) {
                    ContainerPolicy policy = this.getContainerPolicy();
                    Object resultCollection = policy.containerInstance(results.size());
                    Object iterator = policy.iteratorFor(results);
                    while (policy.hasNext(iterator)) {
                        Object result = ((UnitOfWorkImpl)session).registerExistingObject(policy.next(iterator, session), this.descriptor);
                        policy.addInto(result, resultCollection, session);
                    }
                    return resultCollection;
                }
                return results;
            }
            session.incrementProfile("Counter:CacheMisses", this);
        }
        if (QueryMonitor.shouldMonitor()) {
            QueryMonitor.incrementReadAllMisses(this);
        }
        return super.execute(session, row);
    }

    @Override
    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        Object result = null;
        if (this.containerPolicy.overridesRead()) {
            this.executionTime = System.currentTimeMillis();
            return this.containerPolicy.execute();
        }
        if (this.descriptor.isDescriptorForInterface()) {
            Object returnValue = this.descriptor.getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
            this.executionTime = System.currentTimeMillis();
            return returnValue;
        }
        if (this.descriptor.hasTablePerClassPolicy() && this.descriptor.isAbstract()) {
            result = this.containerPolicy.containerInstance();
        } else {
            Vector rows = this.getQueryMechanism().selectAllRows();
            this.executionTime = System.currentTimeMillis();
            if (this.hasJoining() && this.joinedAttributeManager.isToManyJoin()) {
                this.joinedAttributeManager.setDataResults(rows, this.session);
            }
            if (this.batchFetchPolicy != null && this.batchFetchPolicy.isIN()) {
                this.batchFetchPolicy.setDataResults(rows);
            }
            if (this.session.isUnitOfWork()) {
                result = this.registerResultInUnitOfWork(rows, (UnitOfWorkImpl)this.session, this.translationRow, true);
            } else {
                result = this.containerPolicy.containerInstance(rows.size());
                this.descriptor.getObjectBuilder().buildObjectsInto(this, rows, result);
            }
            if (this.shouldIncludeData) {
                ComplexQueryResult complexResult = new ComplexQueryResult();
                complexResult.setResult(result);
                complexResult.setData(rows);
                result = complexResult;
            }
        }
        if (this.descriptor.hasTablePerClassPolicy()) {
            result = this.containerPolicy.concatenateContainers(result, this.descriptor.getTablePerClassPolicy().selectAllObjectsUsingMultipleTableSubclassRead(this), this.session);
        }
        if (this.shouldCacheQueryResults() && this.containerPolicy.isEmpty(result)) {
            this.temporaryCachedQueryResults = InvalidObject.instance();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException {
        ArrayList<Object> arrayList;
        AbstractSession session = this.session;
        DatabasePlatform platform = session.getPlatform();
        DatabaseCall call = (DatabaseCall)((CallQueryMechanism)this.queryMechanism).getCall();
        call.returnCursor();
        call = this.queryMechanism.cursorSelectAllRows();
        Statement statement = call.getStatement();
        ResultSet resultSet = call.getResult();
        DatabaseAccessor accessor = (DatabaseAccessor)((List)this.accessors).get(0);
        boolean exceptionOccured = false;
        try {
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                ArrayList<Object> results = new ArrayList<Object>();
                ObjectBuilder builder = this.descriptor.getObjectBuilder();
                while (resultSet.next()) {
                    results.add(builder.buildObjectFromResultSet(this, this.joinedAttributeManager, resultSet, session, accessor, metaData, platform));
                }
                arrayList = results;
                Object var13_14 = null;
            }
            catch (SQLException exception) {
                exceptionOccured = true;
                DatabaseException commException = accessor.processExceptionForCommError(session, exception, call);
                if (commException == null) throw DatabaseException.sqlException(exception, call, accessor, session, false);
                throw commException;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    accessor.releaseStatement(statement, call.getSQLString(), call, session);
                }
                if (accessor == null) throw throwable;
                session.releaseReadConnection(accessor);
                throw throwable;
            }
            catch (SQLException exception2) {
                if (exceptionOccured) throw throwable;
                DatabaseException commException = accessor.processExceptionForCommError(session, exception2, call);
                if (commException == null) throw DatabaseException.sqlException(exception2, call, accessor, session, false);
                throw commException;
            }
        }
        try {}
        catch (SQLException exception2) {
            if (exceptionOccured) return arrayList;
            DatabaseException commException = accessor.processExceptionForCommError(session, exception2, call);
            if (commException == null) throw DatabaseException.sqlException(exception2, call, accessor, session, false);
            throw commException;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            accessor.releaseStatement(statement, call.getSQLString(), call, session);
        }
        if (accessor == null) return arrayList;
        session.releaseReadConnection(accessor);
        return arrayList;
    }

    @Override
    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectsCorrespondingToAll(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashMap(), this, this.getContainerPolicy());
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    @Override
    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReadAllQueryRedirector();
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public List<Expression> getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public boolean hasHierarchicalExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null;
    }

    @Override
    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && !this.hasBatchReadAttributes() && !this.hasHierarchicalExpressions() && !this.containerPolicy.isCursorPolicy();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReadAllQuery query = (ReadAllQuery)object;
        return this.containerPolicy.equals(query.containerPolicy);
    }

    @Override
    public boolean isReadAllQuery() {
        return true;
    }

    @Override
    protected void prepare() throws QueryException {
        if (!this.isReportQuery() && this.prepareFromCachedQuery()) {
            return;
        }
        super.prepare();
        this.containerPolicy.prepare(this, this.getSession());
        if (this.containerPolicy.overridesRead()) {
            return;
        }
        if (this.descriptor.isDescriptorForInterface()) {
            return;
        }
        this.prepareSelectAllRows();
    }

    @Override
    public void prepareFromQuery(DatabaseQuery query) {
        super.prepareFromQuery(query);
        if (query.isReadAllQuery()) {
            ReadAllQuery readQuery = (ReadAllQuery)query;
            this.containerPolicy = readQuery.containerPolicy;
            if (readQuery.hasHierarchicalExpressions()) {
                this.orderSiblingsByExpressions = readQuery.orderSiblingsByExpressions;
                this.connectByExpression = readQuery.connectByExpression;
                this.startWithExpression = readQuery.startWithExpression;
            }
        }
    }

    @Override
    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        ReadAllQuery customReadQuery = (ReadAllQuery)customQuery;
        customReadQuery.containerPolicy = this.containerPolicy;
        customReadQuery.cascadePolicy = this.cascadePolicy;
        customReadQuery.shouldRefreshIdentityMapResult = this.shouldRefreshIdentityMapResult;
        customReadQuery.shouldMaintainCache = this.shouldMaintainCache;
        customReadQuery.shouldUseWrapperPolicy = this.shouldUseWrapperPolicy;
    }

    @Override
    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.containerPolicy.prepareForExecution();
        if (this.descriptor.hasTenantDiscriminatorFields()) {
            this.translationRow = this.translationRow.clone();
            this.descriptor.getObjectBuilder().addTenantDiscriminatorFieldToRow(this.translationRow, this.getSession());
        }
    }

    protected void prepareSelectAllRows() {
        this.getQueryMechanism().prepareSelectAllRows();
    }

    @Override
    public Object registerResultInUnitOfWork(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        if (unitOfWork.hasCloneMapping() && (this.shouldConformResultsInUnitOfWork() || this.descriptor.shouldAlwaysConformResultsInUnitOfWork())) {
            return this.conformResult(result, unitOfWork, arguments, buildDirectlyFromRows);
        }
        if (buildDirectlyFromRows) {
            List rows = result;
            ContainerPolicy cp = this.containerPolicy;
            int size = rows.size();
            Object clones = cp.containerInstance(size);
            if (cp.shouldAddAll()) {
                ArrayList<Object> clonesIn = new ArrayList<Object>(size);
                ArrayList<AbstractRecord> rowsIn = new ArrayList<AbstractRecord>(size);
                for (int index = 0; index < size; ++index) {
                    AbstractRecord row = (AbstractRecord)rows.get(index);
                    if (row == null) continue;
                    Object clone = this.buildObject(row);
                    clonesIn.add(clone);
                    rowsIn.add(row);
                }
                cp.addAll(clonesIn, clones, (AbstractSession)unitOfWork, rowsIn, this, null, true);
            } else {
                for (int index = 0; index < size; ++index) {
                    AbstractRecord row = (AbstractRecord)rows.get(index);
                    if (row == null) continue;
                    Object clone = this.buildObject(row);
                    cp.addInto(clone, clones, (AbstractSession)unitOfWork, row, this, null, true);
                }
            }
            return clones;
        }
        Cursor cursor = null;
        ContainerPolicy cp = this.getRedirector() != null ? ContainerPolicy.buildPolicyFor(result.getClass()) : this.containerPolicy;
        if (cp.isCursorPolicy()) {
            cursor = (Cursor)((Object)result);
            cursor.setSession(unitOfWork);
            cp = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
            result = cursor.getObjectCollection();
        }
        Object clones = cp.containerInstance(cp.sizeFor(result));
        AbstractSession sessionToUse = unitOfWork.getParent();
        Object iter = cp.iteratorFor(result);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, sessionToUse);
            Object clone = this.registerIndividualResult(object, null, unitOfWork, this.joinedAttributeManager, null);
            cp.addInto(clone, clones, unitOfWork);
        }
        if (cursor != null) {
            cursor.setObjectCollection((Vector)clones);
            return cursor;
        }
        return clones;
    }

    @Override
    public Object remoteExecute() {
        if (this.containerPolicy.overridesRead()) {
            return this.containerPolicy.remoteExecute();
        }
        Object cacheHit = this.checkEarlyReturn(this.session, this.translationRow);
        if (cacheHit != null) {
            return cacheHit;
        }
        return super.remoteExecute();
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersInAll(object, this.getContainerPolicy());
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
        this.setIsPrepared(false);
    }

    public void setHierarchicalQueryClause(Expression startWith, Expression connectBy, List<Expression> orderSiblingsExpressions) {
        this.startWithExpression = startWith;
        this.connectByExpression = connectBy;
        this.orderSiblingsByExpressions = orderSiblingsExpressions;
        this.setIsPrepared(false);
    }

    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public void useCursoredStream(int initialReadSize, int pageSize) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, initialReadSize, pageSize));
    }

    public void useCursoredStream(int initialReadSize, int pageSize, ValueReadQuery sizeQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, initialReadSize, pageSize, sizeQuery));
    }

    public void useMapClass(Class concreteClass, String methodName) {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int pageSize) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, pageSize));
    }

    public void useScrollableCursor(ScrollableCursorPolicy policy) {
        policy.setQuery(this);
        this.setContainerPolicy(policy);
    }
}

