/*
 * Decompiled with CFR 0.152.
 */
package pkg.sun.servicetag;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    private static boolean verbose = System.getProperty("servicetag.verbose") != null;
    private static String jrepath = null;
    private static int jdkVersion = 0;
    private static int jdkUpdate = 0;

    Util() {
    }

    static boolean isVerbose() {
        return verbose;
    }

    static synchronized String getJrePath() {
        String string;
        File file;
        if (jrepath == null && !(file = new File(jrepath = (string = System.getProperty("java.home")) + File.separator + "jre", "lib")).exists()) {
            jrepath = string;
        }
        return jrepath;
    }

    static boolean isJdk() {
        return false;
    }

    static String generateURN() {
        return "urn:st:" + UUID.randomUUID().toString();
    }

    static int getIntValue(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("\"" + string + "\"" + " expected to be an integer");
        }
    }

    static String formatTimestamp(Date date) {
        if (date == null) {
            return "[No timestamp]";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    static Date parseTimestamp(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return new Date();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String commandOutput(Process process) throws IOException {
        InputStreamReader inputStreamReader = null;
        Reader reader = null;
        try {
            inputStreamReader = new InputStreamReader(process.getInputStream());
            reader = new InputStreamReader(process.getErrorStream());
            String string = Util.commandOutput(inputStreamReader);
            String string2 = Util.commandOutput(reader);
            process.waitFor();
            String string3 = string + string2.trim();
            return string3;
        }
        catch (InterruptedException interruptedException) {
            if (Util.isVerbose()) {
                interruptedException.printStackTrace();
            }
            String string = interruptedException.getMessage();
            return string;
        }
        finally {
            if (inputStreamReader != null) {
                ((Reader)inputStreamReader).close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    static String commandOutput(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) > 0) {
            if (n == 13) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    static int getJdkVersion() {
        Util.parseVersion();
        return jdkVersion;
    }

    static int getUpdateVersion() {
        Util.parseVersion();
        return jdkUpdate;
    }

    private static synchronized void parseVersion() {
    }

    private static byte[] stringToByteArray(String string) {
        return (string + "\u0000").getBytes();
    }

    private static String byteArrayToString(byte[] byArray) {
        return new String(byArray, 0, byArray.length - 1);
    }

    static File getWindowsStClientFile() {
        File file = null;
        String string = "software\\microsoft\\windows\\currentversion\\app paths\\stclient.exe";
        String string2 = "";
        String string3 = Util.getRegistryKey(string, string2);
        if (string3 != null && new File(string3).exists()) {
            file = new File(string3);
        }
        if (Util.isVerbose()) {
            System.out.println("stclient=" + file);
        }
        return file;
    }

    private static String getRegistryKey(String string, String string2) {
        String string3;
        block3: {
            string3 = null;
            try {
                Class<?> clazz = Class.forName("java.util.prefs.WindowsPreferences");
                Method method = clazz.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                method.setAccessible(true);
                Method method2 = clazz.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                method2.setAccessible(true);
                Method method3 = clazz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                method3.setAccessible(true);
                int n = Util.getValueFromStaticField("HKEY_LOCAL_MACHINE", clazz);
                int n2 = Util.getValueFromStaticField("KEY_READ", clazz);
                int n3 = Util.getValueFromStaticField("ERROR_CODE", clazz);
                int n4 = Util.getValueFromStaticField("NATIVE_HANDLE", clazz);
                int n5 = Util.getValueFromStaticField("ERROR_SUCCESS", clazz);
                byte[] byArray = Util.stringToByteArray(string);
                byte[] byArray2 = Util.stringToByteArray(string2);
                int[] nArray = (int[])method.invoke(null, n, byArray, n2);
                if (nArray[n3] == n5) {
                    byte[] byArray3 = (byte[])method3.invoke(null, nArray[n4], byArray2);
                    string3 = Util.byteArrayToString(byArray3);
                    method2.invoke(null, nArray[n4]);
                }
            }
            catch (Exception exception) {
                if (!Util.isVerbose()) break block3;
                exception.printStackTrace();
            }
        }
        return string3;
    }

    private static int getValueFromStaticField(String string, Class<?> clazz) throws Exception {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        return field.getInt(null);
    }
}

