/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.work.CommonWorkManager;
import com.sun.enterprise.connectors.work.WorkManagerProxy;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.WorkManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public final class WorkManagerFactory
implements com.sun.appserv.connectors.internal.api.WorkManagerFactory {
    private static final String DEFAULT = "com.sun.enterprise.connectors.work.CommonWorkManager";
    private static final String WORK_MANAGER_CLASS = "workmanager.class";
    private static final Logger logger = LogDomains.getLogger(WorkManagerFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(WorkManagerFactory.class);
    protected static final Map<String, WorkManager> workManagers = Collections.synchronizedMap(new HashMap());
    @Inject
    private Habitat connectorRuntimeHabitat;
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(WorkManagerFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    public WorkManager createWorkManager(String poolName, String raName, ClassLoader rarCL) {
        String className = null;
        String methodName = "getInstance";
        Class<?> cls = null;
        WorkManager wm = null;
        try {
            className = System.getProperty(WORK_MANAGER_CLASS, DEFAULT);
            if (className.equals(DEFAULT)) {
                return new CommonWorkManager(poolName, this.getConnectorRuntime(), raName, rarCL);
            }
            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (cls != null) {
                Method method = cls.getMethod(methodName, new Class[0]);
                wm = (WorkManager)method.invoke(cls, new Object[0]);
            }
        }
        catch (Exception e) {
            String msg = localStrings.getString("workmanager.instantiation_error", (Object)raName);
            logger.log(Level.SEVERE, msg, e);
        }
        return wm;
    }

    static void addWorkManager(String moduleName, WorkManager wm) {
        workManagers.put(moduleName, wm);
    }

    static WorkManager retrieveWorkManager(String moduleName) {
        return workManagers.get(moduleName);
    }

    public boolean removeWorkManager(String moduleName) {
        boolean result = true;
        WorkManager wm = workManagers.remove(moduleName);
        if (wm == null) {
            _logger.log(Level.FINE, "Failed to remove workManager for RAR [ " + moduleName + " ] from registry.");
            result = false;
        } else {
            _logger.log(Level.FINE, "Removed the workManager for RAR [ " + moduleName + " ] from registry.");
            if (wm instanceof CommonWorkManager) {
                ((CommonWorkManager)wm).cleanUp();
            }
        }
        return result;
    }

    public WorkManager getWorkManagerProxy(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        WorkManager wm = WorkManagerFactory.retrieveWorkManager(moduleName);
        if (wm == null) {
            wm = this.createWorkManager(poolId, moduleName, rarCL);
            WorkManagerFactory.addWorkManager(moduleName, wm);
        }
        return new WorkManagerProxy(wm, moduleName);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class);
        }
        return this.runtime;
    }
}

