/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedOSGiGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private BundleContext bundleContext;
    private String installRoot;
    private static final String mainBundleName = "org.glassfish.core.kernel";
    private static final String JAR_EXT = ".jar";

    @Override
    public boolean handles(BootstrapProperties bsProps) {
        return EmbeddedOSGiGlassFishRuntimeBuilder.class.getName().equals(bsProps.getProperties().getProperty("GlassFish.BUILDER_NAME"));
    }

    @Override
    public GlassFishRuntime build(BootstrapProperties bsProps) throws GlassFishException {
        GlassFishRuntime glassFishRuntime;
        this.bundleContext = this.getBundleContext();
        this.installRoot = bsProps.getInstallRoot();
        this.installAndStartEndorsedBundles();
        this.installBundles();
        this.configureBundles();
        this.startBundles();
        ServiceTracker st = new ServiceTracker(this.bundleContext, GlassFishRuntime.class.getName(), null);
        try {
            st.open();
            glassFishRuntime = (GlassFishRuntime)GlassFishRuntime.class.cast(st.waitForService(0L));
            Object var5_5 = null;
        }
        catch (Exception e) {
            try {
                throw new GlassFishException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                st.close();
                throw throwable;
            }
        }
        st.close();
        return glassFishRuntime;
    }

    private void installAndStartEndorsedBundles() {
        ArrayList<Bundle> endorsedBundles = new ArrayList<Bundle>();
        File endorsedModulesDir = new File(this.installRoot, "modules/endorsed/");
        for (File f : endorsedModulesDir.listFiles()) {
            if (!f.getName().endsWith(JAR_EXT)) continue;
            try {
                endorsedBundles.add(this.bundleContext.installBundle(f.toURI().toString()));
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        for (Bundle b : endorsedBundles) {
            try {
                b.start(1);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    private void configureBundles() {
        if (System.getProperty("GlassFish_Platform") == null) {
            System.setProperty("GlassFish_Platform", "GenericOSGi");
        }
    }

    private void installBundles() {
        for (File jar : this.findJars()) {
            try {
                this.bundleContext.installBundle(jar.toURI().toString());
            }
            catch (BundleException e) {
                System.out.println("Exception installing " + jar.toURI() + " : " + (Object)((Object)e));
            }
        }
    }

    private List<File> findJars() {
        File modulesDir = new File(this.installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final File endorsedModulesDir = new File(modulesDir, "endorsed/");
        final ArrayList<File> jars = new ArrayList<File>();
        modulesDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir) && !pathname.equals(endorsedModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(EmbeddedOSGiGlassFishRuntimeBuilder.JAR_EXT)) {
                    jars.add(pathname);
                }
                return false;
            }
        });
        return jars;
    }

    private void startBundles() {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!mainBundleName.equals(b.getSymbolicName())) continue;
            try {
                b.start(1);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    private BundleContext getBundleContext() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
    }
}

