/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.catalina.filters.FilterBase;

public class CsrfPreventionFilter
extends FilterBase {
    private static final Logger log = Logger.getLogger(CsrfPreventionFilter.class.getName());
    private String randomClass = SecureRandom.class.getName();
    private Random randomSource;
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;

    protected Logger getLogger() {
        return log;
    }

    public void setEntryPoints(String entryPoints) {
        String[] values;
        for (String value : values = entryPoints.split(",")) {
            this.entryPoints.add(value.trim());
        }
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            Class<?> clazz = Class.forName(this.randomClass);
            this.randomSource = (Random)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            ServletException se = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", this.randomClass), e);
            throw se;
        }
        catch (InstantiationException e) {
            ServletException se = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", this.randomClass), e);
            throw se;
        }
        catch (IllegalAccessException e) {
            ServletException se = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", this.randomClass), e);
            throw se;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletResponse wResponse = null;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            boolean skipNonceCheck = false;
            if ("GET".equals(req.getMethod())) {
                String path = req.getServletPath();
                if (req.getPathInfo() != null) {
                    path = path + req.getPathInfo();
                }
                if (this.entryPoints.contains(path)) {
                    skipNonceCheck = true;
                }
            }
            LruCache<String> nonceCache = (LruCache<String>)req.getSession(true).getAttribute("org.apache.catalina.filters.CSRF_NONCE");
            if (!skipNonceCheck) {
                String previousNonce = req.getParameter("org.apache.catalina.filters.CSRF_NONCE");
                if (nonceCache != null && !nonceCache.contains(previousNonce)) {
                    res.sendError(403);
                    return;
                }
            }
            if (nonceCache == null) {
                nonceCache = new LruCache<String>(this.nonceCacheSize);
                req.getSession().setAttribute("org.apache.catalina.filters.CSRF_NONCE", nonceCache);
            }
            String newNonce = this.generateNonce();
            nonceCache.add(newNonce);
            wResponse = new CsrfResponseWrapper(res, newNonce);
        } else {
            wResponse = response;
        }
        chain.doFilter(request, wResponse);
    }

    protected String generateNonce() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        this.randomSource.nextBytes(random);
        for (int j = 0; j < random.length; ++j) {
            byte b1 = (byte)((random[j] & 0xF0) >> 4);
            byte b2 = (byte)(random[j] & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedSizedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private int cacheSize;

        public FixedSizedLinkedHashMap(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LruCache<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final LinkedHashMap<T, T> cache;

        public LruCache(int cacheSize) {
            this.cache = new FixedSizedLinkedHashMap<T, T>(cacheSize);
        }

        public synchronized void add(T key) {
            this.cache.put(key, null);
        }

        public synchronized boolean contains(T key) {
            return this.cache.containsKey(key);
        }
    }

    protected static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private String nonce;

        public CsrfResponseWrapper(HttpServletResponse response, String nonce) {
            super(response);
            this.nonce = nonce;
        }

        @Deprecated
        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }

        public String encodeRedirectURL(String url) {
            return this.addNonce(super.encodeRedirectURL(url));
        }

        @Deprecated
        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        public String encodeURL(String url) {
            return this.addNonce(super.encodeURL(url));
        }

        private String addNonce(String url) {
            int question;
            if (url == null || this.nonce == null) {
                return url;
            }
            String path = url;
            String query = "";
            String anchor = "";
            int pound = path.indexOf(35);
            if (pound >= 0) {
                anchor = path.substring(pound);
                path = path.substring(0, pound);
            }
            if ((question = path.indexOf(63)) >= 0) {
                query = path.substring(question);
                path = path.substring(0, question);
            }
            StringBuilder sb = new StringBuilder(path);
            if (query.length() > 0) {
                sb.append(query);
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append("org.apache.catalina.filters.CSRF_NONCE");
            sb.append('=');
            sb.append(this.nonce);
            sb.append(anchor);
            return sb.toString();
        }
    }
}

