/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.SecKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHandShake
extends HandShake {
    private final SecKey key = new SecKey();

    public ClientHandShake(boolean isSecure, String origin, String serverHostName, String portNumber, String path) {
        super(isSecure, origin, serverHostName, portNumber, path);
    }

    public SecKey getKey() {
        return this.key;
    }

    public void validateServerResponse(Map<String, String> headers) throws HandshakeException {
        if (!"101".equals(headers.get("Response Code"))) {
            throw new HandshakeException(String.format("Response code was not %s: %s", "101", headers.get("Response Code")));
        }
        this.checkForHeader(headers, "upgrade", "websocket");
        this.checkForHeader(headers, "connection", "upgrade");
        this.key.validateServerKey(headers.get("Sec-WebSocket-Accept"));
    }

    private void checkForHeader(Map<String, String> headers, String header, String validValue) {
        String value = headers.get(header);
        if (!validValue.equalsIgnoreCase(value)) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream chunk = new ByteArrayOutputStream();
        chunk.write(String.format("GET %s HTTP/1.1\r\n", this.getResourcePath()).getBytes());
        chunk.write(String.format("Host: %s\r\n", this.getServerHostName()).getBytes());
        chunk.write(String.format("Connection: Upgrade\r\n", new Object[0]).getBytes());
        chunk.write(String.format("Upgrade: WebSocket\r\n", new Object[0]).getBytes());
        chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Key", this.getKey()).getBytes());
        chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Origin", this.getOrigin()).getBytes());
        chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Version", 6).getBytes());
        if (this.getSubProtocol() != null) {
            chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Protocol", this.join(this.getSubProtocol())).getBytes());
        }
        if (this.getExtensions() != null) {
            chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Extensions", this.join(this.getExtensions())).getBytes());
        }
        chunk.write("\r\n".getBytes());
        return chunk.toByteArray();
    }
}

