/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.BaseNetworkHandler;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FramingException;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.ServerHandShake;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.WebSocketSelectionKeyAttachment;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNetworkHandler
extends BaseNetworkHandler {
    private final Request request;
    private final Response response;
    private final InternalInputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;
    private final ByteChunk chunk = new ByteChunk();
    private WebSocket socket;
    private WebSocketSelectionKeyAttachment attachment;
    private byte[] mask;
    private int maskIndex = 0;

    public ServerNetworkHandler(Request req, Response resp) {
        this.request = req;
        this.response = resp;
        this.inputBuffer = (InternalInputBuffer)req.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)resp.getOutputBuffer();
    }

    public ServerNetworkHandler(ProcessorTask task, AsyncProcessorTask async, Request req, Response resp) {
        this(req, resp);
        this.attachment = new WebSocketSelectionKeyAttachment(this, task, async);
    }

    public WebSocket getWebSocket() {
        return this.socket;
    }

    public void setWebSocket(BaseWebSocket webSocket) {
        this.socket = webSocket;
    }

    protected void handshake(boolean sslSupport) throws HandshakeException {
        boolean secure = "https".equalsIgnoreCase(this.request.scheme().toString()) || sslSupport;
        ServerHandShake server = new ServerHandShake(this.request, secure, this.chunk);
        server.respond(this.response);
        this.socket.onConnect();
        if (this.chunk.getLength() > 0) {
            this.readFrame();
        }
    }

    protected void readFrame() {
        this.fill();
        while (this.socket.isConnected() && this.chunk.getLength() != 0) {
            try {
                this.setMask(this.getUnmasked(4));
                this.unframe().respond(this.getWebSocket());
            }
            catch (FramingException fe) {
                fe.printStackTrace();
                this.socket.close();
            }
        }
    }

    private void setMask(byte[] mask) {
        this.maskIndex = 0;
        this.mask = mask;
    }

    protected void read() {
        try {
            ByteChunk bytes = new ByteChunk(8192);
            int count = 8192;
            while (count == 8192) {
                count = this.inputBuffer.doRead(bytes, this.request);
                this.chunk.append(bytes);
            }
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    public byte get() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            try {
                return (byte)(this.chunk.substract() ^ this.mask[this.maskIndex++ % 4]);
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    public byte[] get(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() >= count) continue;
                    this.read();
                }
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)(bytes[i] ^ this.mask[this.maskIndex++ % 4]);
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    private byte[] getUnmasked(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                this.fill();
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() >= count) continue;
                    this.read();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    private void fill() {
        if (this.chunk.getLength() == 0) {
            this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] bytes) {
        InternalOutputBuffer internalOutputBuffer = this.outputBuffer;
        synchronized (internalOutputBuffer) {
            block5: {
                try {
                    ByteChunk buffer = new ByteChunk();
                    buffer.setBytes(bytes, 0, bytes.length);
                    this.outputBuffer.doWrite(buffer, this.response);
                    this.outputBuffer.flush();
                }
                catch (IOException e) {
                    if (!this.getWebSocket().isConnected()) break block5;
                    throw new WebSocketException(e.getMessage(), e);
                }
            }
        }
    }

    public void send(DataFrame frame) {
        this.write(frame.frame());
    }

    public void setWebSocket(WebSocket webSocket) {
        this.socket = webSocket;
    }

    public HttpServletRequest getRequest() throws IOException {
        GrizzlyRequest r = new GrizzlyRequest();
        r.setRequest(this.request);
        return new WSServletRequestImpl(r);
    }

    public HttpServletResponse getResponse() throws IOException {
        GrizzlyResponse r = new GrizzlyResponse();
        r.setResponse(this.response);
        return new HttpServletResponseImpl(r);
    }

    public SelectedKeyAttachmentLogic getAttachment() {
        return this.attachment;
    }

    private static class WSServletRequestImpl
    extends HttpServletRequestImpl {
        public WSServletRequestImpl(GrizzlyRequest r) throws IOException {
            super(r);
            this.setContextImpl(new ServletContextImpl());
        }
    }
}

