/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.ejb.embedded.DeploymentElement;
import org.glassfish.ejb.embedded.DomainXmlTransformer;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProviderImpl
implements EJBContainerProvider {
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final String GF_EJB_EMBEDDED_PROPERTY_START = "org.glassfish.ejb.embedded.";
    protected static final String KEEP_TEMPORARY_FILES = "org.glassfish.ejb.embedded.keep-temporary-files";
    private static final String SKIP_CLIENT_MODULES = "org.glassfish.ejb.embedded.skip-client-modules";
    private static final String GF_INSTALLATION_ROOT = "org.glassfish.ejb.embedded.glassfish.installation.root";
    private static final String GF_INSTANCE_ROOT = "org.glassfish.ejb.embedded.glassfish.instance.root";
    private static final String GF_DOMAIN_FILE = "org.glassfish.ejb.embedded.glassfish.configuration.file";
    private static final String GF_INSTANCE_REUSE = "org.glassfish.ejb.embedded.glassfish.instance.reuse";
    private static final String GF_WEB_HTTP_PORT = "org.glassfish.ejb.embedded.glassfish.web.http.port";
    private static final String WEAVING = "org.glassfish.persistence.embedded.weaving.enabled";
    private static final Attributes.Name ATTRIBUTE_NAME_SKIP = new Attributes.Name("Bundle-SymbolicName");
    private static final String[] KNOWN_PACKAGES = new String[]{"org.glassfish.", "com.sun.enterprise.", "org.eclipse.", "org.jboss.weld."};
    private static final String[] ATTRIBUTE_VALUES_OK = new String[]{"sample", "test"};
    private static final Logger _logger = LogDomains.getLogger(EJBContainerProviderImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final StringManager localStrings = StringManager.getManager(EJBContainerProviderImpl.class);
    private static final Object lock = new Object();
    private static EJBContainerImpl container;
    private static GlassFishRuntime runtime;
    private static ArchiveFactory archiveFactory;
    private static Class[] ejbAnnotations;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        block16: {
            block14: {
                if (properties != null && properties.get("javax.ejb.embeddable.provider") != null && !properties.get("javax.ejb.embeddable.provider").equals(EJBContainerProviderImpl.GF_PROVIDER_NAME)) {
                    return null;
                }
                if (EJBContainerProviderImpl.container != null && EJBContainerProviderImpl.container.isOpen()) {
                    throw new EJBException(EJBContainerProviderImpl.localStrings.getString("ejb.embedded.exception_exists_container"));
                }
                ok = false;
                l = this.getLocations(properties);
                try {
                    block13: {
                        try {
                            this.createContainer(properties, l);
                            modules = this.addModules(properties, l);
                            if (!DeploymentElement.hasEJBModule(modules)) {
                                EJBContainerProviderImpl._logger.log(Level.SEVERE, "ejb.embedded.no_modules_found");
                            } else {
                                EJBContainerProviderImpl.container.deploy(properties, modules);
                            }
                            ok = true;
                            var5_7 = EJBContainerProviderImpl.container;
                            var7_8 = null;
                            if (ok != false) return var5_7;
                            if (EJBContainerProviderImpl.container == null) break block13;
                            break block14;
                        }
                        catch (EJBException e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            EJBContainerProviderImpl._logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
                            throw new EJBException(t.getMessage());
                        }
                    }
                    return var5_7;
                }
                catch (Throwable var6_12) {
                    var7_9 = null;
                    if (ok || EJBContainerProviderImpl.container == null) throw var6_12;
                    try {
                        EJBContainerProviderImpl._logger.info("[EJBContainerProviderImpl] Cleaning up on failure ...");
                        EJBContainerProviderImpl.container.close();
                    }
                    catch (Throwable t1) {
                        EJBContainerProviderImpl._logger.info("[EJBContainerProviderImpl] Error cleaning up..." + t1);
                    }
                    EJBContainerProviderImpl.container = null;
                    throw var6_12;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 183->200)] { 
lbl46:
            // 1 sources

            EJBContainerProviderImpl._logger.info("[EJBContainerProviderImpl] Cleaning up on failure ...");
            EJBContainerProviderImpl.container.close();
            break block16;
lbl49:
            // 1 sources

            catch (Throwable t1) {
                EJBContainerProviderImpl._logger.info("[EJBContainerProviderImpl] Error cleaning up..." + t1);
            }
        }
        EJBContainerProviderImpl.container = null;
        return var5_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locations createContainer(Map<?, ?> properties, Locations l) throws EJBException {
        Object object = lock;
        synchronized (object) {
            try {
                if (runtime != null) {
                    runtime.shutdown();
                }
                BootstrapProperties bootstrapProperties = new BootstrapProperties();
                Properties newProps = new Properties();
                if (properties != null) {
                    this.copyUserProperties(properties, newProps);
                }
                if (newProps.getProperty(WEAVING) == null) {
                    newProps.setProperty(WEAVING, "false");
                }
                GlassFishProperties glassFishProperties = new GlassFishProperties(newProps);
                if (Boolean.getBoolean(KEEP_TEMPORARY_FILES)) {
                    glassFishProperties.setProperty("org.glassfish.embeddable.autoDelete", "false");
                    glassFishProperties.setConfigFileReadOnly(false);
                }
                if (l != null) {
                    if (l.reuse_instance_location) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("[EJBContainerProviderImpl] Reusing instance location at: " + l.instance_root);
                        }
                        glassFishProperties.setInstanceRoot(l.instance_root.getCanonicalPath());
                    } else {
                        glassFishProperties.setConfigFileURI(l.domain_file.toURI().toString());
                    }
                    bootstrapProperties.setInstallRoot(l.installed_root.getCanonicalPath());
                }
                this.addWebContainerIfRequested(properties, glassFishProperties);
                runtime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProperties);
                GlassFish server = runtime.newGlassFish(glassFishProperties);
                if (l != null && !l.reuse_instance_location) {
                    server.start();
                    EmbeddedSecurity es = (EmbeddedSecurity)server.getService(EmbeddedSecurity.class);
                    Habitat habitat = (Habitat)server.getService(Habitat.class);
                    Thread.sleep(1000L);
                    server.stop();
                    if (es != null) {
                        es.copyConfigFiles(habitat, l.instance_root, l.domain_file);
                    }
                }
                container = new EJBContainerImpl(server);
                archiveFactory = (ArchiveFactory)server.getService(ArchiveFactory.class);
                Sniffer sniffer = (Sniffer)server.getService(Sniffer.class, "Ejb");
                ejbAnnotations = sniffer.getAnnotationTypes();
            }
            catch (Exception e) {
                try {
                    if (container != null) {
                        container.stop();
                    }
                }
                catch (Exception e0) {
                    _logger.log(Level.SEVERE, e0.getMessage(), e0);
                }
                container = null;
                throw new EJBException(e);
            }
        }
        return l;
    }

    private Set<DeploymentElement> addModules(Map<?, ?> properties, Locations l) {
        HashSet<DeploymentElement> modules = new HashSet<DeploymentElement>();
        Object obj = properties == null ? null : properties.get("javax.ejb.embeddable.modules");
        boolean skip_module_with_main_class = this.getBooleanProperty(properties, SKIP_CLIENT_MODULES);
        HashMap<String, Boolean> moduleNames = new HashMap<String, Boolean>();
        if (obj != null) {
            Object[] arr;
            if (obj instanceof String) {
                moduleNames.put(obj, false);
            } else if (obj instanceof String[]) {
                arr = obj;
                for (Object s : arr) {
                    moduleNames.put((String)s, false);
                }
            } else if (obj instanceof File) {
                this.addModule(l, modules, moduleNames, obj);
            } else if (obj instanceof File[]) {
                arr = obj;
                for (Object f : arr) {
                    this.addModule(l, modules, moduleNames, (File)f);
                }
            }
        }
        if (modules.isEmpty()) {
            String[] entries;
            String path = System.getProperty("java.class.path");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerProviderImpl] Looking for EJB modules in classpath: " + path);
            }
            for (String s0 : entries = path.split(File.pathSeparator)) {
                this.addModule(l, modules, moduleNames, new File(s0), skip_module_with_main_class);
            }
            if (!moduleNames.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (Map.Entry entry : moduleNames.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    sb.append((String)entry.getKey()).append(", ");
                }
                int ln = sb.length();
                if (ln > 0) {
                    throw new EJBException("Modules: [" + sb.substring(0, ln - 2) + "] do not match an entry in the classpath");
                }
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentElement getRequestedEJBModuleOrLibrary(File file, Map<String, Boolean> moduleNames) throws Exception {
        DeploymentElement deploymentElement;
        InputStream is;
        block12: {
            DeploymentElement result = null;
            String fileName = file.getName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("... Testing ... " + fileName);
            }
            ReadableArchive archive = null;
            is = null;
            try {
                boolean isEJBModule = false;
                String moduleName = DeploymentUtils.getDefaultEEName((String)fileName);
                archive = archiveFactory.openArchive(file);
                is = this.getDeploymentDescriptor(archive);
                if (is != null) {
                    isEJBModule = true;
                    EjbDeploymentDescriptorFile eddf = new EjbDeploymentDescriptorFile();
                    eddf.setXMLValidation(false);
                    EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)eddf.read(is);
                    ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
                    moduleDesc.setArchiveUri(fileName);
                    moduleName = moduleDesc.getModuleName();
                } else {
                    GenericAnnotationDetector detector = new GenericAnnotationDetector(ejbAnnotations);
                    isEJBModule = detector.hasAnnotationInArchive(archive);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("... is EJB module: " + isEJBModule);
                    if (isEJBModule) {
                        _logger.fine("... is Requested EJB module [" + moduleName + "]: " + (moduleNames.isEmpty() || moduleNames.containsKey(moduleName)));
                    }
                }
                if (!isEJBModule || moduleNames.isEmpty()) {
                    result = new DeploymentElement(file, isEJBModule, moduleName);
                } else if (moduleNames.containsKey(moduleName) && !moduleNames.get(moduleName).booleanValue()) {
                    result = new DeploymentElement(file, isEJBModule, moduleName);
                    moduleNames.put(moduleName, true);
                }
                deploymentElement = result;
                Object var13_12 = null;
                if (archive == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var13_13 = null;
                    if (archive != null) {
                        archive.close();
                    }
                    if (is == null) break block13;
                    is.close();
                }
                throw throwable;
            }
            archive.close();
        }
        if (is != null) {
            is.close();
        }
        return deploymentElement;
    }

    private void addModule(Locations l, Set<DeploymentElement> modules, Map<String, Boolean> moduleNames, File f) {
        this.addModule(l, modules, moduleNames, f, false);
    }

    private void addModule(Locations l, Set<DeploymentElement> modules, Map<String, Boolean> moduleNames, File f, boolean skip_module_with_main_class) {
        try {
            DeploymentElement de;
            if (f.exists() && !this.skipJar(f, l, skip_module_with_main_class) && (de = this.getRequestedEJBModuleOrLibrary(f, moduleNames)) != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("... Added " + (de.isEJBModule() ? "EJB Module" : "library") + " .... " + de.getElement().getName());
                }
                modules.add(de);
            }
        }
        catch (Exception ioe) {
            _logger.log(Level.FINE, "ejb.embedded.io_exception", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean skipJar(File file, Locations l, boolean skip_module_with_main_class) throws Exception {
        block25: {
            block26: {
                if (file.isDirectory()) {
                    block24: {
                        block23: {
                            if (!skip_module_with_main_class) {
                                return false;
                            }
                            m_file = new File(file, "META-INF/MANIFEST.MF");
                            if (!m_file.exists()) {
                                return false;
                            }
                            is = null;
                            try {
                                is = new FileInputStream(m_file);
                                if (this.containsMainClass(new Manifest(is))) {
                                    EJBContainerProviderImpl._logger.info("... skipping entry with a Manifest file with a Main-Class attribute: " + file.getName());
                                    var6_8 = true;
                                    var8_12 = null;
                                    if (is == null) return var6_8;
                                    break block23;
                                }
                                var6_9 = false;
                                break block24;
                            }
                            catch (Throwable var7_20) {
                                var8_14 = null;
                                if (is == null) throw var7_20;
                                try {
                                    is.close();
                                    throw var7_20;
                                }
                                catch (IOException ex) {
                                    EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing Manifest file under " + file + ": ", ex);
                                }
                                throw var7_20;
                            }
                        }
                        ** try [egrp 1[TRYBLOCK] [3 : 126->134)] { 
lbl32:
                        // 1 sources

                        is.close();
                        return var6_8;
lbl34:
                        // 1 sources

                        catch (IOException ex) {
                            EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing Manifest file under " + file + ": ", ex);
                        }
                        return var6_8;
                    }
                    var8_13 = null;
                    if (is == null) return var6_9;
                    ** try [egrp 1[TRYBLOCK] [3 : 126->134)] { 
lbl41:
                    // 1 sources

                    is.close();
                    return var6_9;
lbl43:
                    // 1 sources

                    catch (IOException ex) {
                        EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing Manifest file under " + file + ": ", ex);
                    }
                    return var6_9;
                }
                if (l != null && l.modules_dir != null && l.modules_dir.equals(file.getAbsoluteFile().getParentFile().getAbsolutePath())) {
                    EJBContainerProviderImpl._logger.info("... skipping module: " + file.getName());
                    return true;
                }
                jf = null;
                try {
                    jf = new JarFile(file);
                    m = jf.getManifest();
                    if (m == null) break block25;
                    if (skip_module_with_main_class && this.containsMainClass(m)) {
                        EJBContainerProviderImpl._logger.info("... skipping entry with a Manifest file with a Main-Class attribute: " + file.getName());
                        var6_10 = true;
                        var18_22 = null;
                        if (jf == null) return var6_10;
                        break block26;
                    }
                    attributes = m.getMainAttributes();
                    value = attributes.getValue(EJBContainerProviderImpl.ATTRIBUTE_NAME_SKIP);
                    if (value != null) {
                        for (String skipValue : EJBContainerProviderImpl.KNOWN_PACKAGES) {
                            if (!value.startsWith(skipValue)) continue;
                            for (String okValue : EJBContainerProviderImpl.ATTRIBUTE_VALUES_OK) {
                                if (value.indexOf(okValue) <= 0) continue;
                                var16_39 = false;
                                var18_23 = null;
                                if (jf == null) return var16_39;
                                try {
                                    jf.close();
                                    return var16_39;
                                }
                                catch (IOException ex) {
                                    EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                                }
                                return var16_39;
                            }
                            EJBContainerProviderImpl._logger.info("... skipping entry with a Manifest file with a special attribute: " + file.getName());
                            var12_35 = true;
                            var18_24 = null;
                            if (jf == null) return var12_35;
                            ** try [egrp 3[TRYBLOCK] [9 : 484->492)] { 
lbl84:
                            // 1 sources

                            jf.close();
                            return var12_35;
lbl86:
                            // 1 sources

                            catch (IOException ex) {
                                EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                            }
                            return var12_35;
                        }
                    }
                    break block25;
                }
                catch (Throwable var17_40) {
                    var18_26 = null;
                    if (jf == null) throw var17_40;
                    ** try [egrp 3[TRYBLOCK] [9 : 484->492)] { 
lbl95:
                    // 1 sources

                    jf.close();
                    throw var17_40;
lbl97:
                    // 1 sources

                    catch (IOException ex) {
                        EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                    }
                    throw var17_40;
                }
            }
            ** try [egrp 3[TRYBLOCK] [9 : 484->492)] { 
lbl102:
            // 1 sources

            jf.close();
            return var6_10;
lbl104:
            // 1 sources

            catch (IOException ex) {
                EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
            }
            return var6_10;
        }
        var18_25 = null;
        if (jf == null) return false;
        try {}
        catch (IOException ex) {
            EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
            return false;
        }
        jf.close();
        return false;
    }

    private File getValidFile(String location) {
        File f = new File(location);
        if (!f.exists()) {
            _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", location);
            f = null;
        }
        return f;
    }

    private boolean containsMainClass(Manifest m) {
        if (m != null) {
            Attributes attributes = m.getMainAttributes();
            String value = attributes.getValue(Attributes.Name.MAIN_CLASS);
            return value != null && value.length() > 0;
        }
        return false;
    }

    private Locations getLocations(Map<?, ?> properties) throws EJBException {
        File installed_root;
        Locations l = null;
        String installed_root_location = null;
        String instance_root_location = null;
        String domain_file_location = null;
        boolean reuse_instance_location = false;
        if (properties != null) {
            installed_root_location = (String)properties.get(GF_INSTALLATION_ROOT);
            instance_root_location = (String)properties.get(GF_INSTANCE_ROOT);
            domain_file_location = (String)properties.get(GF_DOMAIN_FILE);
            reuse_instance_location = this.getBooleanProperty(properties, GF_INSTANCE_REUSE);
        }
        if (installed_root_location == null) {
            try {
                installed_root_location = Which.jarFile(this.getClass()).getParentFile().getParentFile().getAbsolutePath();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "ejb.embedded.cannot_determine_installation_location");
                _logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[EJBContainerProviderImpl] installed_root_location : " + installed_root_location);
        }
        if (installed_root_location != null && (installed_root = this.getValidFile(installed_root_location)) != null) {
            File instance_root;
            if (instance_root_location == null) {
                instance_root_location = installed_root_location + File.separatorChar + "domains" + File.separatorChar + "domain1";
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerProviderImpl] instance_root_location: " + instance_root_location);
            }
            if ((instance_root = this.getValidFile(instance_root_location)) != null) {
                File domain_file;
                if (domain_file_location == null) {
                    domain_file_location = instance_root_location + File.separatorChar + "config" + File.separatorChar + "domain.xml";
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[EJBContainerProviderImpl] domain_file_location : " + domain_file_location);
                }
                if ((domain_file = this.getValidFile(domain_file_location)) != null) {
                    if (!reuse_instance_location) {
                        File temp_domain_file = null;
                        try {
                            DomainXmlTransformer dxf = new DomainXmlTransformer(domain_file, _logger);
                            boolean keep_ports = properties == null ? false : properties.get(GF_WEB_HTTP_PORT) != null;
                            temp_domain_file = dxf.transform(keep_ports);
                        }
                        catch (Exception e) {
                            throw new EJBException(localStrings.getString("ejb.embedded.exception_creating_temporary_domain_xml_file"), e);
                        }
                        if (temp_domain_file != null) {
                            domain_file = temp_domain_file;
                        } else {
                            throw new EJBException(localStrings.getString("ejb.embedded.failed_create_temporary_domain_xml_file"));
                        }
                    }
                    l = new Locations(installed_root, instance_root, domain_file, reuse_instance_location);
                }
            }
        }
        return l;
    }

    private InputStream getDeploymentDescriptor(ReadableArchive archive) throws IOException {
        InputStream dd = archive.getEntry("META-INF/ejb-jar.xml");
        if (dd == null) {
            dd = archive.getEntry("WEB-INF/ejb-jar.xml");
        }
        return dd;
    }

    private void addWebContainerIfRequested(Map<?, ?> properties, GlassFishProperties props) throws EJBException {
        String http_port;
        String string = http_port = properties == null ? null : (String)properties.get(GF_WEB_HTTP_PORT);
        if (http_port != null) {
            int port = 8080;
            try {
                port = Integer.valueOf(http_port);
            }
            catch (NumberFormatException e) {
                System.err.println("Using port 8080");
            }
            props.setPort("http-listener", port);
        }
    }

    private void copyUserProperties(Map<?, ?> properties, Properties props) {
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            String sk;
            Object key = entry.getKey();
            if (!(key instanceof String) || (sk = (String)key).startsWith(GF_EJB_EMBEDDED_PROPERTY_START)) continue;
            for (String prefix : KNOWN_PACKAGES) {
                if (!sk.startsWith(prefix)) continue;
                Object value = entry.getValue();
                if (value instanceof String) {
                    props.setProperty(sk, (String)value);
                    continue;
                }
                props.setProperty(sk, value.toString());
            }
        }
    }

    private boolean getBooleanProperty(Map<?, ?> properties, String key) {
        Object value;
        boolean result = false;
        if (properties != null && (value = properties.get(key)) != null) {
            if (value instanceof String) {
                result = Boolean.valueOf((String)value);
            } else {
                try {
                    result = (Boolean)value;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    static {
        ejbAnnotations = null;
    }

    private static class Locations {
        final File installed_root;
        final File instance_root;
        final File domain_file;
        final String modules_dir;
        final boolean reuse_instance_location;

        Locations(File installed_root, File instance_root, File domain_file, boolean reuse_instance_location) {
            this.installed_root = installed_root;
            this.instance_root = instance_root;
            this.domain_file = domain_file;
            this.modules_dir = installed_root != null ? new File(installed_root, "modules").getAbsolutePath() : null;
            this.reuse_instance_location = reuse_instance_location;
        }
    }
}

