/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.TypeClosureLazyValueHolder;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.introspector.jlr.AbstractWeldCallable;
import org.jboss.weld.introspector.jlr.ConstructorSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldParameterImpl;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldConstructorImpl<T>
extends AbstractWeldCallable<T, T, Constructor<T>>
implements WeldConstructor<T> {
    private final Constructor<T> constructor;
    private final List<WeldParameter<?, T>> parameters;
    private final ConstructorSignature signature;

    public static <T> WeldConstructor<T> of(Constructor<T> constructor, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        return new WeldConstructorImpl<T>(constructor, constructor.getDeclaringClass(), constructor.getDeclaringClass(), null, new TypeClosureLazyValueHolder(constructor.getDeclaringClass()), WeldConstructorImpl.buildAnnotationMap(constructor.getAnnotations()), WeldConstructorImpl.buildAnnotationMap(constructor.getDeclaredAnnotations()), declaringClass, classTransformer);
    }

    public static <T> WeldConstructor<T> of(AnnotatedConstructor<T> annotatedConstructor, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        return new WeldConstructorImpl<T>(annotatedConstructor.getJavaMember(), annotatedConstructor.getJavaMember().getDeclaringClass(), annotatedConstructor.getBaseType(), annotatedConstructor, new TypeClosureLazyValueHolder(annotatedConstructor.getTypeClosure()), WeldConstructorImpl.buildAnnotationMap(annotatedConstructor.getAnnotations()), WeldConstructorImpl.buildAnnotationMap(annotatedConstructor.getAnnotations()), declaringClass, classTransformer);
    }

    private WeldConstructorImpl(Constructor<T> constructor, Class<T> rawType, Type type, AnnotatedConstructor<T> annotatedConstructor, LazyValueHolder<Set<Type>> typeClosure, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        super(annotationMap, declaredAnnotationMap, classTransformer, constructor, rawType, type, typeClosure, declaringClass);
        this.constructor = constructor;
        this.parameters = new ArrayList();
        HashMap annotatedTypeParameters = new HashMap();
        if (annotatedConstructor != null) {
            for (AnnotatedParameter annotated : annotatedConstructor.getParameters()) {
                annotatedTypeParameters.put(annotated.getPosition(), annotated);
            }
        }
        int nesting = Reflections.getNesting(declaringClass.getJavaClass());
        if (annotatedConstructor == null) {
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                WeldParameter parameter;
                Type parameterType;
                Class<?> clazz;
                int gi = i - nesting;
                if (constructor.getParameterAnnotations()[i].length > 0) {
                    clazz = constructor.getParameterTypes()[i];
                    parameterType = constructor.getGenericParameterTypes().length > gi && gi >= 0 ? constructor.getGenericParameterTypes()[gi] : clazz;
                    parameter = WeldParameterImpl.of(constructor.getParameterAnnotations()[i], clazz, parameterType, this, i, classTransformer);
                    this.parameters.add(parameter);
                    continue;
                }
                clazz = constructor.getParameterTypes()[i];
                parameterType = constructor.getGenericParameterTypes().length > gi && gi >= 0 ? constructor.getGenericParameterTypes()[gi] : clazz;
                parameter = WeldParameterImpl.of(new Annotation[0], clazz, parameterType, this, i, classTransformer);
                this.parameters.add(parameter);
            }
        } else {
            if (annotatedConstructor.getParameters().size() != constructor.getParameterTypes().length) {
                throw new DefinitionException(ReflectionMessage.INCORRECT_NUMBER_OF_ANNOTATED_PARAMETERS_METHOD, annotatedConstructor.getParameters().size(), annotatedConstructor, annotatedConstructor.getParameters(), Arrays.asList(constructor.getParameterTypes()));
            }
            for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
                WeldParameter parameter = WeldParameterImpl.of(annotatedParameter.getAnnotations(), constructor.getParameterTypes()[annotatedParameter.getPosition()], annotatedParameter.getBaseType(), this, annotatedParameter.getPosition(), classTransformer);
                this.parameters.add(parameter);
            }
        }
        this.signature = new ConstructorSignatureImpl(this);
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public List<WeldParameter<?, T>> getWeldParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<WeldParameter<?, T>> getWeldParameters(Class<? extends Annotation> annotationType) {
        ArrayList ret = new ArrayList();
        for (WeldParameter<?, T> parameter : this.parameters) {
            if (!parameter.isAnnotationPresent(annotationType)) continue;
            ret.add(parameter);
        }
        return ret;
    }

    @Override
    public T newInstance(Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ((Constructor)SecureReflections.ensureAccessible(this.getDelegate())).newInstance(parameters);
    }

    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof WeldConstructor) {
            WeldConstructor that = (WeldConstructor)other;
            return ((Constructor)this.getJavaMember()).equals(that.getJavaMember()) && ((Object)this.getWeldParameters()).equals(that.getWeldParameters());
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + ((Constructor)this.getJavaMember()).hashCode();
        hash = hash * 31 + ((Object)this.getWeldParameters()).hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "[constructor] " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(this.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(((Constructor)this.getJavaMember()).getModifiers())) + this.getDeclaringType().getName() + Formats.formatAsFormalParameterList(this.getWeldParameters());
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }

    @Override
    public List<AnnotatedParameter<T>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public boolean isGeneric() {
        return ((Constructor)this.getJavaMember()).getTypeParameters().length > 0;
    }
}

