/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.grizzly.config.dom.NetworkListener;
import java.io.IOException;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgijavaeebase.DeploymentException;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgiweb.ContextPathCollisionDetector;
import org.glassfish.osgiweb.ContextPathCollisionException;
import org.glassfish.osgiweb.OSGiWebDeployer;
import org.glassfish.osgiweb.OSGiWebDeploymentContext;
import org.glassfish.osgiweb.WAB;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiWebDeploymentRequest
extends OSGiDeploymentRequest {
    private static final Logger logger = Logger.getLogger(OSGiWebDeployer.class.getPackage().getName());
    private static ThreadLocal<BundleContext> currentBundleContext = new ThreadLocal();

    public OSGiWebDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        super(deployer, archiveFactory, env, reporter, b);
    }

    protected OSGiDeploymentContext getDeploymentContextImpl(ActionReport reporter, Logger logger, ReadableArchive archive, OpsParams opsParams, ServerEnvironmentImpl env, Bundle b) throws Exception {
        return new OSGiWebDeploymentContext(reporter, logger, archive, opsParams, (ServerEnvironment)env, b);
    }

    protected WAB makeArchive() {
        Bundle host = this.getBundle();
        Bundle[] fragments = this.getPackageAdmin().getFragments(host);
        return new WAB(host, fragments);
    }

    private PackageAdmin getPackageAdmin() {
        BundleContext ctx = ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
        return (PackageAdmin)PackageAdmin.class.cast(ctx.getService(ctx.getServiceReference(PackageAdmin.class.getName())));
    }

    protected DeployCommandParameters getDeployParams() throws Exception {
        DeployCommandParameters parameters = super.getDeployParams();
        try {
            parameters.contextroot = this.getArchive().getManifest().getMainAttributes().getValue("Web-ContextPath");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (parameters.contextroot == null || parameters.contextroot.length() == 0) {
            throw new Exception("Web-ContextPath manifest header is mandatory");
        }
        parameters.virtualservers = this.getVirtualServers();
        return parameters;
    }

    private String getVirtualServers() {
        StringTokenizer st;
        String virtualServers = null;
        try {
            virtualServers = this.getArchive().getManifest().getMainAttributes().getValue("Virtual-Servers");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (virtualServers == null) {
            virtualServers = this.getDefaultVirtualServer();
        }
        if ((st = new StringTokenizer(virtualServers)).countTokens() > 1) {
            throw new IllegalArgumentException("Currently, we only support deployment to one virtual server.");
        }
        return virtualServers;
    }

    private String getAllVirtualServers() {
        List hosts;
        HttpService httpService;
        Config config;
        String target;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed(target = "server");
        if (server != null && (config = domain.getConfigs().getConfigByName(server.getConfigRef())) != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    private String getDefaultVirtualServer() {
        NetworkListener nl = (NetworkListener)Globals.get(NetworkListener.class);
        return nl.findHttpProtocol().getHttp().getDefaultVirtualServer();
    }

    public void preDeploy() throws DeploymentException {
        this.detectCollisions();
        currentBundleContext.set(this.getBundle().getBundleContext());
    }

    private void detectCollisions() throws ContextPathCollisionException {
        ContextPathCollisionDetector cd = ContextPathCollisionDetector.get();
        cd.preDeploy(this.getBundle());
    }

    public void postDeploy() {
        currentBundleContext.set(null);
        OSGiApplicationInfo osgiAppInfo = this.getResult();
        if (osgiAppInfo == null) {
            ContextPathCollisionDetector cd = ContextPathCollisionDetector.get();
            cd.cleanUp(this.getBundle());
            return;
        }
        ServletContext sc = this.getServletContext(osgiAppInfo.getAppInfo());
        assert (sc.getAttribute("osgi-bundlecontext") == osgiAppInfo.getBundle().getBundleContext());
        try {
            ServiceRegistration scReg = this.registerService(osgiAppInfo.getBundle(), sc);
        }
        catch (IllegalStateException e) {
            logger.logp(Level.WARNING, "OSGiWebDeploymentRequest", "postDeploy", "Failed to register ServletContext for bundle " + osgiAppInfo.getBundle().getBundleId() + " because of following exception:", e);
        }
    }

    private ServletContext getServletContext(ApplicationInfo appInfo) {
        if (appInfo.getModuleInfos().size() == 1) {
            ModuleInfo m = (ModuleInfo)appInfo.getModuleInfos().iterator().next();
            EngineRef e = m.getEngineRefForContainer(WebContainer.class);
            assert (e != null);
            WebApplication a = (WebApplication)e.getApplicationContainer();
            Set wms = a.getWebModules();
            assert (wms.size() == 1);
            if (wms.size() == 1) {
                return ((WebModule)wms.iterator().next()).getServletContext();
            }
        }
        return null;
    }

    private ServiceRegistration registerService(Bundle b, ServletContext sc) {
        BundleContext bctx;
        Properties props = new Properties();
        props.setProperty("osgi.web.symbolicname", b.getSymbolicName());
        String cpath = (String)b.getHeaders().get("Web-ContextPath");
        props.setProperty("osgi.web.contextpath", cpath);
        String version = (String)b.getHeaders().get("Bundle-Version");
        if (version != null) {
            props.setProperty("osgi.web.version", version);
        }
        if ((bctx = b.getBundleContext()) != null) {
            ServiceRegistration scReg = bctx.registerService(ServletContext.class.getName(), (Object)sc, (Dictionary)props);
            logger.logp(Level.INFO, "OSGiWebContainer", "registerService", "Registered ServletContext as a service with properties: {0} ", new Object[]{props});
            return scReg;
        }
        logger.logp(Level.WARNING, "OSGiWebContainer", "registerService", "Not able to register ServletContext as a service as bctx is null");
        return null;
    }

    static BundleContext getCurrentBundleContext() {
        return currentBundleContext.get();
    }
}

