/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.filter;

import com.sun.appserv.web.cache.filter.CachingOutputStreamWrapper;
import com.sun.appserv.web.cache.filter.HttpCacheEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CachingResponseWrapper
extends HttpServletResponseWrapper {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    int statusCode = -1;
    HashMap headers = new HashMap();
    HashMap dateHeaders = new HashMap();
    ArrayList cookies = new ArrayList();
    int contentLength = -1;
    String contentType;
    Locale locale;
    boolean error = false;
    CachingOutputStreamWrapper cosw;
    PrintWriter writer;

    public CachingResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    private CachingOutputStreamWrapper createCachingOutputStreamWrapper() throws IOException {
        return new CachingOutputStreamWrapper();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getOutputStream<>getWriter");
        }
        if (this.cosw == null) {
            this.cosw = this.createCachingOutputStreamWrapper();
        }
        return this.cosw;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.cosw != null) {
            throw new IllegalStateException("getWriter<>getOutputStream");
        }
        this.cosw = this.createCachingOutputStreamWrapper();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.cosw, this.getCharacterEncoding());
        this.writer = new PrintWriter(osw);
        return this.writer;
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        this.contentLength = len;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.put(name, values);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, "" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            HashMap hashMap = this.headers;
            synchronized (hashMap) {
                this.headers.put(name, values);
            }
        }
        values.add(value);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateHeader(String name, long value) {
        super.setDateHeader(name, value);
        ArrayList<Long> values = new ArrayList<Long>();
        values.add(value);
        HashMap hashMap = this.dateHeaders;
        synchronized (hashMap) {
            this.dateHeaders.put(name, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDateHeader(String name, long value) {
        super.addDateHeader(name, value);
        ArrayList<Long> values = (ArrayList<Long>)this.dateHeaders.get(name);
        if (values == null) {
            values = new ArrayList<Long>();
            HashMap hashMap = this.dateHeaders;
            synchronized (hashMap) {
                this.dateHeaders.put(name, values);
            }
        }
        values.add(value);
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.statusCode = sc;
    }

    public void sendError(int status) throws IOException {
        super.sendError(status);
        this.error = true;
    }

    public void sendError(int status, String message) throws IOException {
        super.sendError(status, message);
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public Long getExpiresDateHeader() {
        return (Long)this.dateHeaders.get("Expires");
    }

    public HttpCacheEntry cacheResponse() throws IOException {
        HttpCacheEntry entry = new HttpCacheEntry();
        entry.responseHeaders = this.headers;
        entry.dateHeaders = this.dateHeaders;
        entry.cookies = this.cookies;
        entry.contentLength = this.contentLength;
        entry.contentType = this.contentType;
        entry.locale = this.locale;
        entry.statusCode = this.statusCode;
        if (this.writer != null) {
            this.writer.flush();
        }
        entry.bytes = this.cosw != null ? this.cosw.getBytes() : EMPTY_BYTE_ARRAY;
        return entry;
    }

    public void clear() {
        this.cosw = null;
        this.writer = null;
    }
}

